/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules.passive;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule
public class SmallDustsModule
implements IModule {
    private final IForm smallDustForm = ApiImpl.INSTANCE.newForm(this, "small_dusts", ItemFormType.INSTANCE);

    @Override
    public String getName() {
        return "small_dusts";
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return List.of(this.smallDustForm.toRequest());
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : this.smallDustForm.getMaterials()) {
            ResourceLocation smallDustLocation = miscHelper.getTagLocation("small_dusts", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            ((JAOPCAApi)api).registerShapelessRecipe(miscHelper.getRecipeKey("small_dusts.to_dust", material.getName()), dustLocation, 1, smallDustLocation, smallDustLocation, smallDustLocation, smallDustLocation);
        }
    }
}

