/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.mixins;

import java.util.Collections;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thelm.jaopca.client.models.ModelHandler;

@Mixin(value={ModelBakery.class})
public class ModelBakeryMixin {
    @Shadow
    private Map<ResourceLocation, BlockModel> modelResources;

    @Inject(method={"<init>(Lnet/minecraft/client/color/block/BlockColors;Lnet/minecraft/util/profiling/ProfilerFiller;Ljava/util/Map;Ljava/util/Map;)V"}, at={@At(value="FIELD", shift=At.Shift.AFTER, target="modelResources", opcode=181)})
    public void onInitModelResources(CallbackInfo ci) {
        ModelHandler.gatherItemModelRemaps(Collections.unmodifiableSet(this.modelResources.keySet()));
    }

    @ModifyVariable(method={"loadItemModelAndDependencies(Lnet/minecraft/resources/ResourceLocation;)V"}, at=@At(value="HEAD"), argsOnly=true)
    public ResourceLocation onLoadItemModelAndDependencies(ResourceLocation location) {
        return ModelHandler.remapItemModel(location);
    }
}

