/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.mixins;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thelm.jaopca.client.models.ModelHandler;

@Mixin(value={BlockStateModelLoader.class})
public class BlockStateModelLoaderMixin {
    @Shadow
    private Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>> blockStateResources;

    @Inject(method={"<init>(Ljava/util/Map;Lnet/minecraft/util/profiling/ProfilerFiller;Lnet/minecraft/client/resources/model/UnbakedModel;Lnet/minecraft/client/color/block/BlockColors;Ljava/util/function/BiConsumer;)V"}, at={@At(value="FIELD", shift=At.Shift.AFTER, target="blockStateResources", opcode=181)})
    public void onInitBlockStateResources(CallbackInfo ci) {
        ModelHandler.gatherBlockStateRemaps(Collections.unmodifiableSet(this.blockStateResources.keySet()));
    }

    @ModifyVariable(method={"loadBlockStateDefinitions(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/world/level/block/state/StateDefinition;)V"}, at=@At(value="HEAD"), argsOnly=true)
    public ResourceLocation onLoadBlockStateDefinitions(ResourceLocation location) {
        return ModelHandler.remapBlockModel(location);
    }
}

