/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.materials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialColorEvent;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.client.colors.ColorHandler;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.utils.MiscHelper;

public class Material
implements IMaterial {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> DEFAULT_SMALL_BLOCKS = new TreeSet<String>(List.of("amethyst", "certus_quartz", "quartz"));
    private final String name;
    private final MaterialType type;
    private final TreeSet<String> alternativeNames = new TreeSet();
    private final List<String> extras = new ArrayList<String>();
    private boolean hasEffect = false;
    private final TreeSet<String> configModuleBlacklist = new TreeSet();
    private boolean isSmallStorageBlock;
    private String modelType;
    private Rarity displayRarity = Rarity.COMMON;
    private OptionalInt color = OptionalInt.empty();
    private IDynamicSpecConfig config;
    private HolderSet<Item> tag;
    private boolean shouldFireColorEvent = true;

    public Material(String name, MaterialType type) {
        this.name = name;
        this.type = type;
        this.isSmallStorageBlock = DEFAULT_SMALL_BLOCKS.contains(name);
        this.modelType = switch (type) {
            default -> throw new MatchException(null, null);
            case MaterialType.INGOT, MaterialType.INGOT_LEGACY, MaterialType.INGOT_PLAIN -> "metallic";
            case MaterialType.GEM, MaterialType.GEM_PLAIN, MaterialType.CRYSTAL, MaterialType.CRYSTAL_PLAIN -> "crystal";
            case MaterialType.DUST, MaterialType.DUST_PLAIN -> "dust";
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MaterialType getType() {
        return this.type;
    }

    @Override
    public Set<String> getAlternativeNames() {
        return Collections.unmodifiableNavigableSet(this.alternativeNames);
    }

    @Override
    public IMaterial getExtra(int index) {
        return index == 0 || !this.hasExtra(index) ? this : (IMaterial)Optional.ofNullable(MaterialHandler.getMaterial(this.extras.get(index - 1))).orElse(this);
    }

    @Override
    public boolean hasExtra(int index) {
        return index == 0 || index - 1 < this.extras.size() && !StringUtils.isEmpty((CharSequence)this.extras.get(index - 1));
    }

    @Override
    public boolean isSmallStorageBlock() {
        return this.isSmallStorageBlock;
    }

    @Override
    public Set<String> getConfigModuleBlacklist() {
        return Collections.unmodifiableNavigableSet(this.configModuleBlacklist);
    }

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public int getColor() {
        if (MaterialHandler.clientTagsBound) {
            if (!this.color.isPresent() && this.config != null) {
                MiscHelper.INSTANCE.conditionalRunnable(() -> ((Dist)FMLEnvironment.dist).isClient(), () -> () -> {
                    this.shouldFireColorEvent = false;
                    HolderSet<Item> tag = this.getTag();
                    this.color = OptionalInt.of(0xFFFFFF);
                    MiscHelper.INSTANCE.submitAsyncTask(() -> {
                        try {
                            this.color = OptionalInt.of(this.config.getDefinedInt("general.color", ColorHandler.getAverageColor(tag), "The color of this material."));
                            NeoForge.EVENT_BUS.post((Event)new MaterialColorEvent(this, this.color.getAsInt()));
                        }
                        catch (Exception e) {
                            LOGGER.warn("Unable to get color for material {}", (Object)this.name, (Object)e);
                        }
                    });
                }, () -> () -> {}).run();
            }
            if (this.color.isPresent() && this.shouldFireColorEvent) {
                this.shouldFireColorEvent = false;
                NeoForge.EVENT_BUS.post((Event)new MaterialColorEvent(this, this.color.getAsInt()));
            }
        } else {
            LOGGER.warn("Tried to get color for material {} when tags are not bound", (Object)this.name);
        }
        return 0xFF000000 | this.color.orElse(0xFFFFFF);
    }

    @Override
    public boolean hasEffect() {
        return this.hasEffect;
    }

    @Override
    public Rarity getDisplayRarity() {
        return this.displayRarity;
    }

    public void setConfig(IDynamicSpecConfig config) {
        this.config = config;
        List<String> cfgList = config.getDefinedStringList("general.alternativeNames", new ArrayList<String>(this.alternativeNames), "The alternative names of this material.");
        this.alternativeNames.clear();
        this.alternativeNames.addAll(cfgList);
        cfgList = config.getDefinedStringList("general.extras", this.extras, MaterialHandler::containsMaterial, "The byproducts of this material.");
        this.extras.clear();
        this.extras.addAll(cfgList);
        this.isSmallStorageBlock = config.getDefinedBoolean("general.isSmallStorageBlock", this.isSmallStorageBlock, "Is the storage block of this material small (2x2).");
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateModuleSet(config.getDefinedStringList("general.moduleBlacklist", new ArrayList<String>(this.configModuleBlacklist), helper.configModulePredicate(), "The module blacklist of this material."), this.configModuleBlacklist);
        this.hasEffect = config.getDefinedBoolean("general.hasEffect", this.hasEffect, "Should items of this material have the enchanted glow.");
        this.modelType = config.getDefinedString("general.modelType", this.modelType, s -> Material.isModelTypeValid(s), "The model type of the material.");
        if (ConfigHandler.resetColors) {
            config.remove("general.color");
        }
        this.color = config.getOptionalInt("general.color");
    }

    private HolderSet<Item> getTag() {
        if (this.tag == null) {
            this.tag = BuiltInRegistries.ITEM.getOrCreateTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)(this.type.getFormName() + "/" + this.name))));
        }
        return this.tag;
    }

    public String toString() {
        return "Material:" + this.name;
    }

    private static boolean isModelTypeValid(String modelType) {
        return modelType.chars().allMatch(c -> c == 95 || c == 45 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 47 || c == 46);
    }
}

