/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.localization;

import java.util.Arrays;
import java.util.Map;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.localization.ILocalizer;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class LocalizerDefault
implements ILocalizer {
    public static final LocalizerDefault INSTANCE = new LocalizerDefault();

    private LocalizerDefault() {
    }

    @Override
    public MutableComponent localizeMaterialForm(String formTranslationKey, IMaterial material, String overrideKey) {
        Language languageMap = Language.getInstance();
        Map<String, String> locMap = ApiImpl.INSTANCE.currentMaterialLocalizationMap();
        if (languageMap.has(overrideKey)) {
            return Component.translatable((String)overrideKey);
        }
        if (locMap.containsKey(overrideKey)) {
            return Component.literal((String)locMap.get(overrideKey));
        }
        String materialKey = "jaopca.material." + material.getName();
        String materialName = languageMap.has(materialKey) ? languageMap.getOrDefault(materialKey) : (locMap.containsKey(materialKey) ? locMap.get(materialKey) : LocalizerDefault.splitAndCapitalize(material.getName()));
        if (languageMap.has(formTranslationKey) || !locMap.containsKey(formTranslationKey)) {
            return Component.translatable((String)formTranslationKey, (Object[])new Object[]{materialName});
        }
        return Component.literal((String)String.format(locMap.get(overrideKey), materialName));
    }

    public static String splitAndCapitalize(String underscore) {
        return Arrays.stream(StringUtils.split((String)underscore, (char)'_')).map(StringUtils::capitalize).reduce((s1, s2) -> s1 + " " + s2).orElse("");
    }
}

