/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.items;

import java.util.function.BooleanSupplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCAItem
extends Item
implements IMaterialFormItem {
    private final IForm form;
    private final IMaterial material;
    protected final IItemFormSettings settings;
    protected BooleanSupplier hasEffect;

    public JAOPCAItem(IForm form, IMaterial material, IItemFormSettings settings) {
        super(JAOPCAItem.getProperties(form, material, settings));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.hasEffect = MemoizingSuppliers.of(settings.getHasEffectFunction(), () -> material);
    }

    public static Item.Properties getProperties(IForm form, IMaterial material, IItemFormSettings settings) {
        Item.Properties prop = new Item.Properties();
        prop.rarity(settings.getDisplayRarityFunction().apply(material));
        return prop;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public boolean isFoil(ItemStack stack) {
        return this.hasEffect.getAsBoolean() || super.isFoil(stack);
    }

    public Component getName(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("item.jaopca." + this.form.getName(), this.material, this.getDescriptionId(stack));
    }
}

