/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.ingredients;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import thelm.jaopca.ingredients.IngredientTypes;

public class WrappedIngredient
implements ICustomIngredient {
    public static final MapCodec<WrappedIngredient> CODEC = Ingredient.CODEC.fieldOf("wrapped").xmap(WrappedIngredient::new, WrappedIngredient::getWrapped);
    private final Ingredient wrapped;

    protected WrappedIngredient(Ingredient wrapped) {
        this.wrapped = wrapped;
    }

    public static Ingredient of(Ingredient wrapped) {
        return new WrappedIngredient(wrapped).toVanilla();
    }

    public Ingredient getWrapped() {
        return this.wrapped;
    }

    public IngredientType<?> getType() {
        return (IngredientType)IngredientTypes.WRAPPED_INGREDIENT_TYPE.get();
    }

    public boolean test(ItemStack stack) {
        return this.wrapped.test(stack);
    }

    public Stream<ItemStack> getItems() {
        return Arrays.stream(this.wrapped.getItems());
    }

    public boolean isSimple() {
        return this.wrapped.isSimple();
    }
}

