/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.data;

import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagFile;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DataMapLoader;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.commons.lang3.ClassUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import thelm.jaopca.api.data.IDataModule;
import thelm.jaopca.api.data.JAOPCADataModule;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.resources.InMemoryResourcePack;
import thelm.jaopca.utils.MiscHelper;

public class DataInjector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FileToIdConverter LOOT_TABLE_FORMAT = FileToIdConverter.json((String)"loot_table");
    private static final FileToIdConverter ADVANCEMENT_FORMAT = FileToIdConverter.json((String)"advancement");
    private static final Type JAOPCA_DATA_MODULE = Type.getType(JAOPCADataModule.class);
    private static final Map<Class<?>, Consumer<Object>> RELOAD_INJECTORS = new HashMap();
    private static final LoadingCache<ResourceKey<? extends Registry<?>>, ListMultimap<ResourceLocation, ResourceLocation>> TAGS_INJECT = CacheBuilder.newBuilder().build(CacheLoader.from(() -> MultimapBuilder.treeKeys().arrayListValues().build()));
    private static final TreeMap<ResourceLocation, IRecipeSerializer> RECIPES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<LootTable>> LOOT_TABLES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<Advancement.Builder>> ADVANCEMENTS_INJECT = new TreeMap();
    private static final Table<DataMapType<?, ?>, ExtraCodecs.TagOrElementLocation, Supplier<?>> DATA_MAPS_INJECT = Tables.newCustomTable(new TreeMap(Comparator.comparing(t -> t.id())), () -> new TreeMap(Comparator.comparing(t -> t.toString())));

    public static void init() {
        RELOAD_INJECTORS.put(RecipeManager.class, DataInjector::injectRecipes);
    }

    public static boolean registerReloadInjector(Class<?> clazz, Consumer<Object> injector) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(injector);
        return RELOAD_INJECTORS.putIfAbsent(clazz, injector) == null;
    }

    public static boolean registerTag(ResourceKey<? extends Registry<?>> registry, ResourceLocation tagLocation, ResourceLocation objLocation) {
        Objects.requireNonNull(registry);
        Objects.requireNonNull(tagLocation);
        Objects.requireNonNull(objLocation);
        return ((ListMultimap)TAGS_INJECT.getUnchecked(registry)).put((Object)tagLocation, (Object)objLocation);
    }

    public static boolean registerRecipe(ResourceLocation location, IRecipeSerializer recipeSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(recipeSupplier);
        return RECIPES_INJECT.putIfAbsent(location, recipeSupplier) == null;
    }

    public static boolean registerLootTable(ResourceLocation location, Supplier<LootTable> lootTableSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(lootTableSupplier);
        return LOOT_TABLES_INJECT.putIfAbsent(location, lootTableSupplier) == null;
    }

    public static boolean registerAdvancement(ResourceLocation location, Supplier<Advancement.Builder> advancementBuilder) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(advancementBuilder);
        return ADVANCEMENTS_INJECT.putIfAbsent(location, advancementBuilder) == null;
    }

    public static <T> boolean registerDataMapEntry(DataMapType<?, T> type, ExtraCodecs.TagOrElementLocation location, Supplier<T> value) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(location);
        Objects.requireNonNull(value);
        if (DATA_MAPS_INJECT.contains(type, (Object)location)) {
            return false;
        }
        DATA_MAPS_INJECT.put(type, (Object)location, value);
        return true;
    }

    public static Set<ResourceLocation> getInjectTags(ResourceKey<? extends Registry<?>> registry) {
        Objects.requireNonNull(registry);
        return ((ListMultimap)TAGS_INJECT.getUnchecked(registry)).keySet();
    }

    public static Set<ResourceLocation> getInjectRecipes() {
        return RECIPES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectLootTables() {
        return LOOT_TABLES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectAdvancements() {
        return ADVANCEMENTS_INJECT.navigableKeySet();
    }

    public static Set<ExtraCodecs.TagOrElementLocation> getInjectDataMapEntries(DataMapType<?, ?> type) {
        Objects.requireNonNull(type);
        return DATA_MAPS_INJECT.rowMap().getOrDefault(type, Map.of()).keySet();
    }

    public static void findDataModules() {
        TreeMap<String, IDataModule> dataModules = new TreeMap<String, IDataModule>();
        List<ModFileScanData.AnnotationData> annotationData = ModList.get().getAllScanData().stream().flatMap(data -> data.getAnnotations().stream()).filter(data -> JAOPCA_DATA_MODULE.equals((Object)data.annotationType())).toList();
        Predicate<String> modVersionNotLoaded = MiscHelper.INSTANCE.modVersionNotLoaded(LOGGER);
        Predicate<String> classNotExists = MiscHelper.INSTANCE::classNotExists;
        for (ModFileScanData.AnnotationData aData : annotationData) {
            List modDeps = (List)aData.annotationData().get("modDependencies");
            List classDeps = (List)aData.annotationData().get("classDependencies");
            String className = aData.clazz().getClassName();
            if (modDeps != null && modDeps.stream().filter(Predicates.notNull()).anyMatch(modVersionNotLoaded)) {
                LOGGER.info("Data module {} has missing mod dependencies, skipping", (Object)className);
                continue;
            }
            if (classDeps != null && classDeps.stream().filter(Predicates.notNull()).anyMatch(classNotExists)) {
                LOGGER.info("Data module {} has missing class dependencies, skipping", (Object)className);
                continue;
            }
            try {
                IDataModule module;
                Class<?> moduleClass = Class.forName(className);
                Class<IDataModule> moduleInstanceClass = moduleClass.asSubclass(IDataModule.class);
                try {
                    Method method = moduleClass.getMethod("getInstance", new Class[0]);
                    module = (IDataModule)method.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    module = moduleInstanceClass.newInstance();
                }
                if (ConfigHandler.DATA_MODULE_BLACKLIST.contains(module.getName())) {
                    LOGGER.info("Data module {} is disabled in config, skipping", (Object)module.getName());
                }
                if (dataModules.putIfAbsent(module.getName(), module) != null) {
                    LOGGER.fatal("Data module name conflict: {} for {} and {}", (Object)module.getName(), ((IDataModule)dataModules.get(module.getName())).getClass(), module.getClass());
                    continue;
                }
                LOGGER.debug("Loaded data module {}", (Object)module.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.fatal("Unable to load data module {}", (Object)className, (Object)e);
            }
        }
        for (IDataModule module : dataModules.values()) {
            module.register();
        }
    }

    public static void reloadInject(Class<?> clazz, Object object) {
        for (Class c : ClassUtils.hierarchy(clazz, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE)) {
            if (!RELOAD_INJECTORS.containsKey(c)) continue;
            RELOAD_INJECTORS.get(c).accept(object);
            return;
        }
    }

    public static void injectRecipes(Object object) {
        Map recipeMap = (Map)object;
        TreeMap<ResourceLocation, JsonElement> recipesToInject = new TreeMap<ResourceLocation, JsonElement>();
        RECIPES_INJECT.forEach((key, supplier) -> {
            if (recipeMap.containsKey(key)) {
                LOGGER.debug("Duplicate recipe ignored with ID {}", key);
                return;
            }
            JsonElement recipe = null;
            try {
                recipe = (JsonElement)supplier.get();
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Recipe with ID {} received invalid arguments: {}", key, (Object)e.getMessage());
                return;
            }
            catch (Throwable e) {
                LOGGER.warn("Recipe with ID {} errored", key, (Object)e);
                return;
            }
            if (recipe == null) {
                LOGGER.debug("Recipe with ID {} returned null", key);
                return;
            }
            recipesToInject.put((ResourceLocation)key, recipe);
            LOGGER.debug("Injected recipe with ID {}", key);
        });
        recipesToInject.forEach(recipeMap::putIfAbsent);
        LOGGER.info("Injected {} recipes, {} recipes total", (Object)recipesToInject.size(), (Object)recipeMap.size());
    }

    public static <T> JsonElement serialize(Codec<T> codec, T value) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow();
    }

    public static JsonElement serializeTag(TagBuilder tagBuilder) {
        return DataInjector.serialize(TagFile.CODEC, new TagFile(tagBuilder.build(), false, List.of()));
    }

    public static JsonElement serializeLootTable(LootTable lootTable) {
        return DataInjector.serialize(LootTable.DIRECT_CODEC, lootTable);
    }

    public static JsonElement serializeAdvancement(Advancement.Builder advancementBuilder) {
        return DataInjector.serialize(Advancement.CODEC, advancementBuilder.build(null).value());
    }

    public static class PackFinder
    implements RepositorySource {
        public static final PackFinder INSTANCE = new PackFinder();

        public void loadPacks(Consumer<Pack> packConsumer) {
            PackLocationInfo packLocation = new PackLocationInfo("jaopca:inmemory", (Component)Component.literal((String)"JAOPCA In Memory Resources"), PackSource.BUILT_IN, Optional.empty());
            PackSelectionConfig packSelection = new PackSelectionConfig(true, Pack.Position.BOTTOM, false);
            Pack packInfo = Pack.readMetaAndCreate((PackLocationInfo)packLocation, (Pack.ResourcesSupplier)BuiltInPackSource.fromName(packId -> {
                InMemoryResourcePack pack = new InMemoryResourcePack((PackLocationInfo)packId, true);
                TAGS_INJECT.asMap().forEach((registry, map) -> {
                    FileToIdConverter format = FileToIdConverter.json((String)Registries.tagsDirPath((ResourceKey)registry));
                    map.asMap().forEach((tagLocation, objLocations) -> {
                        TagBuilder builder = TagBuilder.create();
                        objLocations.forEach(l -> builder.addOptionalElement(l));
                        pack.putJson(PackType.SERVER_DATA, format.idToFile(tagLocation), DataInjector.serializeTag(builder));
                    });
                });
                LOOT_TABLES_INJECT.forEach((location, supplier) -> pack.putJson(PackType.SERVER_DATA, LOOT_TABLE_FORMAT.idToFile(location), DataInjector.serializeLootTable((LootTable)supplier.get())));
                ADVANCEMENTS_INJECT.forEach((location, supplier) -> pack.putJson(PackType.SERVER_DATA, ADVANCEMENT_FORMAT.idToFile(location), DataInjector.serializeAdvancement((Advancement.Builder)supplier.get())));
                DATA_MAPS_INJECT.rowMap().forEach((type, map) -> {
                    FileToIdConverter format = FileToIdConverter.json((String)("data_maps/" + DataMapLoader.getFolderLocation((ResourceLocation)type.registryKey().location())));
                    JsonObject values = new JsonObject();
                    map.forEach((location, supplier) -> {
                        JsonElement value = DataInjector.serialize(type.codec(), supplier.get());
                        values.add(location.toString(), value);
                    });
                    JsonObject json = new JsonObject();
                    json.add("values", (JsonElement)values);
                    pack.putJson(PackType.SERVER_DATA, format.idToFile(type.id()), (JsonElement)json);
                });
                ModuleHandler.onCreateDataPack(pack);
                return pack;
            }), (PackType)PackType.SERVER_DATA, (PackSelectionConfig)packSelection);
            if (packInfo != null) {
                packConsumer.accept(packInfo);
            }
        }
    }
}

