/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.custom.CustomCodecs;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.forms.Form;
import thelm.jaopca.forms.FormRequest;

@JAOPCAModule
public class CustomModule
implements IModule {
    private static final Logger LOGGER = LogManager.getLogger();
    public static CustomModule instance;
    private final Codec<IForm> formCodec = CustomCodecs.FORM_TYPE.dispatch("type", IForm::getType, type -> CustomCodecs.builder(kind -> kind.group((App)Codec.STRING.fieldOf("name").forGetter(IForm::getName)).apply((Applicative)kind, name -> new Form(this, (String)name, (IFormType)type))).withField(Codec.STRING.optionalFieldOf("secondaryName"), IForm::getSecondaryName, IForm::setSecondaryName).withField(CustomCodecs.setOf(CustomCodecs.MATERIAL_TYPE).optionalFieldOf("materialTypes"), IForm::getMaterialTypes, IForm::setMaterialTypes).withField(CustomCodecs.setOf(Codec.STRING).optionalFieldOf("defaultMaterialBlacklist"), IForm::getDefaultMaterialBlacklist, IForm::setDefaultMaterialBlacklist).withField(Codec.BOOL.optionalFieldOf("skipGroupedCheck"), IForm::skipGroupedCheck, IForm::setSkipGroupedCheck).withField(Codec.STRING.optionalFieldOf("tagSeparator"), IForm::getTagSeparator, IForm::setTagSeparator).withField(type.formSettingsCodec().optionalFieldOf("settings"), IForm::getSettings, IForm::setSettings).mapCodec());
    private final Codec<IFormRequest> formRequestCodec = Codec.either(this.formCodec, (Codec)this.formCodec.listOf()).xmap(either -> (IFormRequest)either.map(IForm::toRequest, forms -> new FormRequest(this, (IForm[])forms.stream().toArray(IForm[]::new))), request -> Either.right(request.getForms()));
    private final List<IFormRequest> formRequests = new ArrayList<IFormRequest>();

    public CustomModule() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public String getName() {
        return "custom";
    }

    public void setCustomFormConfigFile(Path customFormConfigFile) {
        this.formRequests.clear();
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(customFormConfigFile, new OpenOption[0]), StandardCharsets.UTF_8);){
            JsonElement json = JsonParser.parseReader((Reader)reader);
            if (!json.isJsonNull()) {
                List requests = CustomCodecs.listOrSingle(this.formRequestCodec).parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).orElse(List.of());
                this.formRequests.addAll(requests);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to read custom json", (Throwable)e);
        }
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return this.formRequests;
    }
}

