/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.Lists;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.config.DynamicSpecConfig;
import thelm.jaopca.custom.CustomModule;
import thelm.jaopca.data.DataCollector;
import thelm.jaopca.materials.Material;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleData;
import thelm.jaopca.modules.ModuleHandler;

public class ConfigHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Path configDir;
    private static Path customFormConfigFile;
    private static Path materialConfigDir;
    private static Path moduleConfigDir;
    private static IDynamicSpecConfig mainConfig;
    public static final TreeMap<IMaterial, IDynamicSpecConfig> MATERIAL_CONFIGS;
    public static final TreeMap<IModule, IDynamicSpecConfig> MODULE_CONFIGS;
    public static boolean ingot;
    public static boolean ingotLegacy;
    public static boolean gem;
    public static boolean crystal;
    public static boolean dust;
    public static boolean ingotPlain;
    public static boolean gemPlain;
    public static boolean crystalPlain;
    public static boolean dustPlain;
    public static final List<String> DEFAULT_GEM_OVERRIDES;
    public static final List<String> DEFAULT_CRYSTAL_OVERRIDES;
    public static final List<String> DEFAULT_DUST_OVERRIDES;
    public static final Set<String> GEM_OVERRIDES;
    public static final Set<String> CRYSTAL_OVERRIDES;
    public static final Set<String> DUST_OVERRIDES;
    private static final List<String> DEFAULT_PREFERRED_MODS;
    public static final List<String> PREFERRED_MODS;
    public static final Set<ResourceLocation> BLOCK_TAG_BLACKLIST;
    public static final Set<ResourceLocation> ITEM_TAG_BLACKLIST;
    public static final Set<ResourceLocation> FLUID_TAG_BLACKLIST;
    public static final Set<ResourceLocation> ENTITY_TYPE_TAG_BLACKLIST;
    public static final Set<ResourceLocation> RECIPE_BLACKLIST;
    public static final List<Pattern> RECIPE_REGEX_BLACKLIST;
    public static final Set<ResourceLocation> LOOT_TABLE_BLACKLIST;
    public static final Set<ResourceLocation> ADVANCEMENT_BLACKLIST;
    public static final Set<String> DATA_MODULE_BLACKLIST;
    public static double gammaValue;
    public static boolean resetColors;
    public static boolean checkL10nUpdates;
    public static double updateInterval;

    private ConfigHandler() {
    }

    public static void setupMainConfig() {
        configDir = FMLPaths.CONFIGDIR.get().resolve("jaopca");
        if (!Files.exists(configDir, new LinkOption[0]) || !Files.isDirectory(configDir, new LinkOption[0])) {
            try {
                if (Files.exists(configDir, new LinkOption[0]) && !Files.isDirectory(configDir, new LinkOption[0])) {
                    LOGGER.warn("Config directory {} is a file, deleting", (Object)configDir);
                    Files.delete(configDir);
                }
                Files.createDirectory(configDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create config directory " + String.valueOf(configDir), e);
            }
        }
        mainConfig = new DynamicSpecConfig((CommentedConfig)CommentedFileConfig.builder((Path)configDir.resolve("main.toml")).sync().backingMapCreator(LinkedHashMap::new).autosave().build());
        mainConfig.setComment("materials", "Configurations related to materials.");
        ingot = mainConfig.getDefinedBoolean("materials.ingot", ingot, "Should the mod find ingot materials with ores.");
        ingotLegacy = mainConfig.getDefinedBoolean("materials.ingotLegacy", ingot, "Should the mod find ingot materials with ores but without raw ores.");
        gem = mainConfig.getDefinedBoolean("materials.gem", gem, "Should the mod find gem materials with ores.");
        crystal = mainConfig.getDefinedBoolean("materials.crystal", crystal, "Should the mod find crystal materials with ores.");
        dust = mainConfig.getDefinedBoolean("materials.dust", dust, "Should the mod find dust materials with ores.");
        ingotPlain = mainConfig.getDefinedBoolean("materials.ingotPlain", ingotPlain, "Should the mod find ingot materials without ores.");
        gemPlain = mainConfig.getDefinedBoolean("materials.gemPlain", gemPlain, "Should the mod find gem materials without ores.");
        crystalPlain = mainConfig.getDefinedBoolean("materials.crystalPlain", crystalPlain, "Should the mod find crystal materials without ores.");
        dustPlain = mainConfig.getDefinedBoolean("materials.dustPlain", dustPlain, "Should the mod find dust materials without ores.");
        mainConfig.setComment("materialOverrides", "Configurations related to material overrides.");
        GEM_OVERRIDES.addAll(mainConfig.getDefinedStringList("materialOverrides.gem", DEFAULT_GEM_OVERRIDES, "List of materials that should be gems."));
        CRYSTAL_OVERRIDES.addAll(mainConfig.getDefinedStringList("materialOverrides.crystal", DEFAULT_CRYSTAL_OVERRIDES, "List of materials that should be crystals."));
        DUST_OVERRIDES.addAll(mainConfig.getDefinedStringList("materialOverrides.dust", DEFAULT_DUST_OVERRIDES, "List of materials that should be dusts."));
        mainConfig.setComment("itemSelection", "Configurations related to item selection.");
        PREFERRED_MODS.addAll(mainConfig.getDefinedStringList("itemSelection.preferredMods", DEFAULT_PREFERRED_MODS, "List of mods that are preferred when selecting items in recipes."));
        mainConfig.setComment("blockTags", "Configurations related to block tags.");
        BLOCK_TAG_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("blockTags.blacklist", new ArrayList<String>(), "List of block tags that should not be added."), ResourceLocation::parse));
        DataCollector.getDefinedTags("blocks").addAll(Lists.transform(mainConfig.getDefinedStringList("blockTags.customDefined", new ArrayList<String>(), "List of block tags that should be considered as defined."), ResourceLocation::parse));
        mainConfig.setComment("itemTags", "Configurations related to item tags.");
        ITEM_TAG_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("itemTags.blacklist", new ArrayList<String>(), "List of item tags that should not be added."), ResourceLocation::parse));
        DataCollector.getDefinedTags("items").addAll(Lists.transform(mainConfig.getDefinedStringList("itemTags.customDefined", new ArrayList<String>(), "List of item tags that should be considered as defined."), ResourceLocation::parse));
        mainConfig.setComment("fluidTags", "Configurations related to fluid tags.");
        FLUID_TAG_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("fluidTags.blacklist", new ArrayList<String>(), "List of fluid tags that should not be added."), ResourceLocation::parse));
        DataCollector.getDefinedTags("fluids").addAll(Lists.transform(mainConfig.getDefinedStringList("fluidTags.customDefined", new ArrayList<String>(), "List of fluid tags that should be considered as defined."), ResourceLocation::parse));
        mainConfig.setComment("entityTypeTags", "Configurations related to entity type tags.");
        ENTITY_TYPE_TAG_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("entityTypeTags.blacklist", new ArrayList<String>(), "List of entity type tags that should not be added."), ResourceLocation::parse));
        DataCollector.getDefinedTags("entity_types").addAll(Lists.transform(mainConfig.getDefinedStringList("entityTypeTags.customDefined", new ArrayList<String>(), "List of entity type tags that should be considered as defined."), ResourceLocation::parse));
        mainConfig.setComment("recipes", "Configurations related to recipes.");
        RECIPE_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("recipes.blacklist", new ArrayList<String>(), "List of recipes that should not be added."), ResourceLocation::parse));
        RECIPE_REGEX_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("recipes.regexBlacklist", new ArrayList<String>(), "List of recipes by regex that should not be added."), Pattern::compile));
        mainConfig.setComment("lootTables", "Configurations related to loot tables.");
        LOOT_TABLE_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("lootTables.blacklist", new ArrayList<String>(), "List of loot tables that should not be added."), ResourceLocation::parse));
        mainConfig.setComment("advancements", "Configurations related to advancements.");
        ADVANCEMENT_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("advancements.blacklist", new ArrayList<String>(), "List of advancements that should not be added."), ResourceLocation::parse));
        mainConfig.setComment("data", "Configurations related to data modules.");
        DATA_MODULE_BLACKLIST.addAll(mainConfig.getDefinedStringList("data.moduleBlacklist", new ArrayList<String>(), "List of data modules that should not be registered."));
        mainConfig.setComment("colors", "Configurations related to color generation.");
        gammaValue = mainConfig.getDefinedDouble("colors.gammaValue", gammaValue, "The gamma value used to blend colors.");
        resetColors = mainConfig.getDefinedBoolean("colors.resetColors", false, "Should colors of all materials be reset on next startup.");
        mainConfig.set("colors.resetColors", false);
        mainConfig.setComment("materialLocalization", "Configurations related to material localization.");
        checkL10nUpdates = mainConfig.getDefinedBoolean("materialLocalization.checkL10nUpdates", checkL10nUpdates, "Should the mod check for material localization updates.");
        updateInterval = mainConfig.getDefinedDouble("materialLocalization.updateInterval", updateInterval, "The update interval of localization files in days.");
    }

    public static void setupCustomFormConfig() {
        customFormConfigFile = configDir.resolve("custom_forms.json");
        try {
            if (!Files.exists(customFormConfigFile, new LinkOption[0])) {
                Files.createFile(customFormConfigFile, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create config file " + String.valueOf(customFormConfigFile), e);
        }
        CustomModule.instance.setCustomFormConfigFile(customFormConfigFile);
    }

    public static void setupMaterialConfigs() {
        materialConfigDir = configDir.resolve("materials");
        if (!Files.exists(materialConfigDir, new LinkOption[0]) || !Files.isDirectory(materialConfigDir, new LinkOption[0])) {
            try {
                if (Files.exists(materialConfigDir, new LinkOption[0]) && !Files.isDirectory(materialConfigDir, new LinkOption[0])) {
                    LOGGER.warn("Config directory {} is a file, deleting", (Object)materialConfigDir);
                    Files.delete(materialConfigDir);
                }
                Files.createDirectory(materialConfigDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create config directory " + String.valueOf(materialConfigDir), e);
            }
        }
        MATERIAL_CONFIGS.clear();
        for (Material material : MaterialHandler.getMaterials()) {
            DynamicSpecConfig config = new DynamicSpecConfig((CommentedConfig)CommentedFileConfig.builder((Path)materialConfigDir.resolve(material.getName() + ".toml")).sync().backingMapCreator(LinkedHashMap::new).autosave().build());
            MATERIAL_CONFIGS.put(material, config);
            material.setConfig(config);
        }
    }

    public static void setupModuleConfigsPre() {
        moduleConfigDir = configDir.resolve("modules");
        if (!Files.exists(moduleConfigDir, new LinkOption[0]) || !Files.isDirectory(moduleConfigDir, new LinkOption[0])) {
            try {
                if (Files.exists(moduleConfigDir, new LinkOption[0]) && !Files.isDirectory(moduleConfigDir, new LinkOption[0])) {
                    LOGGER.warn("Config directory {} is a file, deleting", (Object)moduleConfigDir);
                    Files.delete(moduleConfigDir);
                }
                Files.createDirectory(moduleConfigDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create config directory " + String.valueOf(moduleConfigDir), e);
            }
        }
        for (IModule module : ModuleHandler.getModules()) {
            DynamicSpecConfig config = new DynamicSpecConfig((CommentedConfig)CommentedFileConfig.builder((Path)moduleConfigDir.resolve(module.getName() + ".toml")).sync().backingMapCreator(LinkedHashMap::new).autosave().build());
            MODULE_CONFIGS.put(module, config);
            ModuleData data = ModuleHandler.getModuleData(module);
            data.setConfig(config);
            module.defineModuleConfigPre(data, config);
            module.onMaterialConfigAvailable(data, Collections.unmodifiableNavigableMap(MATERIAL_CONFIGS));
        }
    }

    public static void setupModuleConfigs() {
        for (IModule module : ModuleHandler.getModules()) {
            IDynamicSpecConfig config = MODULE_CONFIGS.get(module);
            ModuleData data = ModuleHandler.getModuleData(module);
            module.defineModuleConfig(data, config);
        }
    }

    static {
        MATERIAL_CONFIGS = new TreeMap();
        MODULE_CONFIGS = new TreeMap();
        ingot = true;
        ingotLegacy = true;
        gem = true;
        crystal = true;
        dust = true;
        ingotPlain = true;
        gemPlain = true;
        crystalPlain = true;
        dustPlain = true;
        DEFAULT_GEM_OVERRIDES = Lists.newArrayList((Object[])new String[]{"diamond", "emerald", "lapis", "prismarine", "quartz"});
        DEFAULT_CRYSTAL_OVERRIDES = Lists.newArrayList();
        DEFAULT_DUST_OVERRIDES = Lists.newArrayList((Object[])new String[]{"glowstone", "redstone"});
        GEM_OVERRIDES = new TreeSet<String>();
        CRYSTAL_OVERRIDES = new TreeSet<String>();
        DUST_OVERRIDES = new TreeSet<String>();
        DEFAULT_PREFERRED_MODS = Lists.newArrayList((Object[])new String[]{"minecraft"});
        PREFERRED_MODS = new ArrayList<String>();
        BLOCK_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
        ITEM_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
        FLUID_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
        ENTITY_TYPE_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
        RECIPE_BLACKLIST = new TreeSet<ResourceLocation>();
        RECIPE_REGEX_BLACKLIST = new ArrayList<Pattern>();
        LOOT_TABLE_BLACKLIST = new TreeSet<ResourceLocation>();
        ADVANCEMENT_BLACKLIST = new TreeSet<ResourceLocation>();
        DATA_MODULE_BLACKLIST = new TreeSet<String>();
        gammaValue = 2.0;
        resetColors = false;
        checkL10nUpdates = true;
        updateInterval = 3.0;
    }
}

