/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.theurgy.items;

import com.klikli_dev.theurgy.content.item.derivative.render.AlchemicalDerivativeBEWLR;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurType;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.compat.theurgy.TheurgyModule;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAAlchemicalSulfurItem
extends AlchemicalSulfurItem
implements IMaterialFormItem {
    private final IForm form;
    private final IMaterial material;

    public JAOPCAAlchemicalSulfurItem(IForm form, IMaterial material, IItemFormSettings settings) {
        super(JAOPCAAlchemicalSulfurItem.getProperties(form, material, settings));
        this.form = form;
        this.material = material;
        this.tier = TheurgyModule.TIER_FUNCTION.apply(material);
        this.type = switch (material.getType()) {
            case MaterialType.INGOT, MaterialType.INGOT_LEGACY -> AlchemicalSulfurType.METALS;
            case MaterialType.GEM, MaterialType.CRYSTAL -> AlchemicalSulfurType.GEMS;
            default -> AlchemicalSulfurType.OTHER_MINERALS;
        };
    }

    public static Item.Properties getProperties(IForm form, IMaterial material, IItemFormSettings settings) {
        Item.Properties prop = new Item.Properties();
        ResourceLocation tagLocation = MiscHelper.INSTANCE.getTagLocation(material.getType().getFormName(), material.getName());
        prop.component((DataComponentType)DataComponentRegistry.SOURCE_TAG.get(), MiscHelper.INSTANCE.getItemTagKey(tagLocation));
        return prop;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public MutableComponent getSourceName(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("%s", this.material, "%s").withStyle(Style.EMPTY.withColor(this.tier.color()).withItalic(Boolean.valueOf(true)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.jaopca.theurgy_alchemical_sulfurs.tooltip", (Object[])new Object[]{this.getSourceName(stack), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)this.tier.descriptionId()).withStyle(Style.EMPTY.withColor(this.tier.color).withItalic(Boolean.valueOf(true)))), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)this.type.descriptionId()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withItalic(Boolean.valueOf(true))))}).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)"item.jaopca.theurgy_alchemical_sulfurs", (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)this.getSourceName(stack))});
    }

    @Override
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return AlchemicalDerivativeBEWLR.get();
            }
        });
    }
}

