/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.chemicals;

import com.google.common.base.Strings;
import java.util.function.Supplier;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.mekanism.api.chemicals.IChemicalFormSettings;
import thelm.jaopca.compat.mekanism.api.chemicals.IMaterialFormChemical;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAChemical
extends Chemical
implements IMaterialFormChemical {
    private final IForm form;
    private final IMaterial material;
    protected final IChemicalFormSettings settings;
    protected Supplier<TagKey<Item>> oreTag;

    public JAOPCAChemical(IForm form, IMaterial material, IChemicalFormSettings settings) {
        super(ChemicalBuilder.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jaopca", (String)("chemical/" + material.getModelType() + "/" + form.getName()))));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.oreTag = MemoizingSuppliers.of(() -> {
            String tag = settings.getOreTagFunction().apply(material);
            return Strings.isNullOrEmpty((String)tag) ? null : MiscHelper.INSTANCE.getItemTagKey(ResourceLocation.parse((String)tag));
        });
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public TagKey<Item> getOreTag() {
        return this.oreTag.get();
    }

    public int getTint() {
        return 0xFFFFFF & this.material.getColor();
    }

    public ResourceLocation getIcon() {
        if (MiscHelper.INSTANCE.hasResource(this.getRegistryName().withPath("textures/chemical/" + this.getRegistryName().getPath() + ".png"))) {
            return this.getRegistryName().withPath("chemical/" + this.getRegistryName().getPath());
        }
        return super.getIcon();
    }

    public Component getTextComponent() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("chemical.jaopca." + this.form.getName(), this.material, this.getTranslationKey());
    }
}

