/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.integrateddynamics.recipes;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class MechanicalSqueezerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] itemOutput;
    public final Object fluidOutput;
    public final int fluidOutputAmount;
    public final int time;

    public MechanicalSqueezerRecipeSerializer(ResourceLocation key, Object input, Object[] itemOutput, int time) {
        this(key, input, itemOutput, Fluids.EMPTY, 0, time);
    }

    public MechanicalSqueezerRecipeSerializer(ResourceLocation key, Object input, Object[] itemOutput, Object fluidOutput, int fluidOutputAmount, int time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        NonNullList itemResults = NonNullList.create();
        int i = 0;
        while (i < this.itemOutput.length) {
            ItemStack stack;
            Object out = this.itemOutput[i];
            Integer count = 1;
            if (++i < this.itemOutput.length && this.itemOutput[i] instanceof Integer) {
                count = (Integer)this.itemOutput[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.itemOutput.length && this.itemOutput[i] instanceof Float) {
                chance = (Float)this.itemOutput[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)) == null) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            itemResults.add((Object)new RecipeSqueezer.IngredientChance(Either.left((Object)Pair.of((Object)stack, (Object)chance))));
        }
        FluidStack fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        if (itemResults.isEmpty() && fluidStack.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.itemOutput) + ", " + String.valueOf(this.fluidOutput));
        }
        RecipeMechanicalSqueezer recipe = new RecipeMechanicalSqueezer(ing, itemResults, fluidStack.isEmpty() ? Optional.empty() : Optional.of(fluidStack), this.time);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

