/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering.recipes;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class ArcFurnaceRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object slag;
    public final int slagCount;
    public final Object[] output;
    public final int time;
    public final int energy;

    public ArcFurnaceRecipeSerializer(ResourceLocation key, Object[] input, Object[] output, int time, int energy) {
        this(key, input, ItemStack.EMPTY, 0, output, time, energy);
    }

    public ArcFurnaceRecipeSerializer(ResourceLocation key, Object[] input, Object slag, int slagCount, Object[] output, int time, int energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.slag = slag;
        this.slagCount = slagCount;
        this.output = output;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        IngredientWithSize ing = null;
        ArrayList<IngredientWithSize> additives = new ArrayList<IngredientWithSize>();
        int i = 0;
        while (i < this.input.length) {
            Ingredient is;
            Object in = this.input[i];
            Integer count = 1;
            if (++i < this.input.length && this.input[i] instanceof Integer) {
                count = (Integer)this.input[i];
                ++i;
            }
            if ((is = MiscHelper.INSTANCE.getIngredient(in)) == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(in));
            }
            if (ing == null) {
                ing = new IngredientWithSize(is, count.intValue());
                continue;
            }
            additives.add(new IngredientWithSize(is, count.intValue()));
        }
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.input));
        }
        ArrayList<TagOutput> outputs = new ArrayList<TagOutput>();
        ArrayList<StackWithChance> secondary = new ArrayList<StackWithChance>();
        i = 0;
        while (i < this.output.length) {
            Ingredient is;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((is = MiscHelper.INSTANCE.getIngredient(out)) == null) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            if (chance.floatValue() == 1.0f) {
                outputs.add(new TagOutput(new IngredientWithSize(is, count.intValue())));
                continue;
            }
            secondary.add(new StackWithChance(new TagOutput(new IngredientWithSize(is, count.intValue())), chance.floatValue(), new ICondition[0]));
        }
        if (outputs.isEmpty() && secondary.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.output));
        }
        Ingredient slagIng = MiscHelper.INSTANCE.getIngredient(this.slag);
        TagOutput slagOutput = slagIng == null ? TagOutput.EMPTY : new TagOutput(new IngredientWithSize(slagIng, this.slagCount));
        ArcFurnaceRecipe recipe = new ArcFurnaceRecipe(new TagOutputList(outputs), slagOutput, secondary, this.time, this.energy, ing, additives);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

