/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.immersiveengineering.ImmersiveEngineeringHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"immersiveengineering"})
public class ImmersiveEngineeringNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("coal", "diamond", "emerald", "fluorite", "lapis", "quartz", "redstone"));

    @Override
    public String getName() {
        return "immersiveengineering_non_ingot";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)1, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ImmersiveEngineeringHelper helper = ImmersiveEngineeringHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            int outputCount;
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation extraDustLocation = miscHelper.getTagLocation("dusts", material.getExtra(1).getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            int n = outputCount = material.getType() != MaterialType.DUST ? 2 : 5;
            if (material.hasExtra(1)) {
                helper.registerCrusherRecipe(miscHelper.getRecipeKey("immersiveengineering.ore_to_material", material.getName()), oreLocation, new Object[]{materialLocation, outputCount, extraDustLocation, 1, Float.valueOf(0.2f)}, 6000);
                continue;
            }
            helper.registerCrusherRecipe(miscHelper.getRecipeKey("immersiveengineering.ore_to_material", material.getName()), oreLocation, new Object[]{materialLocation, outputCount}, 6000);
        }
    }
}

