/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.energizedpower.recipes;

import com.google.gson.JsonElement;
import java.util.Objects;
import me.jddev0.ep.recipe.CompressorRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class CompressorRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;

    public CompressorRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        CompressorRecipe recipe = new CompressorRecipe(stack, ing, this.inputCount);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

