/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.enderio.recipes;

import com.enderio.machines.common.recipe.SagMillingRecipe;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class SagMillingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int energy;
    public final SagMillingRecipe.BonusType bonusType;
    public final Object[] output;

    public SagMillingRecipeSerializer(ResourceLocation key, Object input, int energy, String bonusType, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.energy = energy;
        this.bonusType = Objects.requireNonNull(SagMillingRecipe.BonusType.valueOf((String)bonusType.toUpperCase(Locale.US)));
        this.output = output;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ArrayList<SagMillingRecipe.OutputItem> outputs = new ArrayList<SagMillingRecipe.OutputItem>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(new SagMillingRecipe.OutputItem(Either.left((Object)stack), chance.floatValue(), false));
        }
        SagMillingRecipe recipe = new SagMillingRecipe(ing, outputs, this.energy, this.bonusType);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

