/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.google.common.collect.TreeBasedTable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;
import thelm.jaopca.api.blocks.IBlockLike;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materialforms.IMaterialFormInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.crafttweaker.Form;
import thelm.jaopca.compat.crafttweaker.Material;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.jaopca.MaterialForm")
public class MaterialForm {
    private static final TreeBasedTable<IForm, IMaterial, MaterialForm> MATERIAL_FORM_WRAPPERS = TreeBasedTable.create();
    private final IMaterialFormInfo info;

    public static MaterialForm getMaterialFormWrapper(IForm form, IMaterial material) {
        MaterialForm materialForm = (MaterialForm)MATERIAL_FORM_WRAPPERS.get((Object)form, (Object)material);
        if (materialForm == null) {
            IMaterialFormInfo info = form.getType().getMaterialFormInfo(form, material);
            materialForm = new MaterialForm(info);
        }
        return materialForm;
    }

    private MaterialForm(IMaterialFormInfo info) {
        this.info = info;
    }

    public IMaterialFormInfo getInternal() {
        return this.info;
    }

    @ZenCodeType.Getter(value="form")
    public Form getForm() {
        return Form.getFormWrapper(this.info.getMaterialForm().getForm());
    }

    @ZenCodeType.Getter(value="material")
    public Material getMaterial() {
        return Material.getMaterialWrapper(this.info.getMaterialForm().getMaterial());
    }

    @ZenCodeType.Method
    public MCTag asItemTag() {
        return this.asTag(Registries.ITEM);
    }

    @ZenCodeType.Method
    public MCTag asFluidTag() {
        return this.asTag(Registries.FLUID);
    }

    @ZenCodeType.Method
    public MCTag asTag(ResourceLocation registry) {
        return this.asTag(ResourceKey.createRegistryKey((ResourceLocation)registry));
    }

    public <T> MCTag asTag(ResourceKey<? extends Registry<T>> registry) {
        return this.asTag(CraftTweakerTagRegistry.INSTANCE.tagManager(registry));
    }

    @ZenCodeType.Method
    public MCTag asTag(ITagManager<?> tagManager) {
        return tagManager.tag(MiscHelper.INSTANCE.getTagLocation(this.info.getMaterialForm().getForm().getSecondaryName(), this.info.getMaterialForm().getMaterial().getName(), this.info.getMaterialForm().getForm().getTagSeparator()));
    }

    @ZenCodeType.Method
    public IItemStack asItemStack(int count) {
        IMaterialFormInfo iMaterialFormInfo = this.info;
        if (iMaterialFormInfo instanceof ItemLike) {
            ItemLike item = (ItemLike)iMaterialFormInfo;
            return IItemStack.of((ItemStack)new ItemStack(item, count));
        }
        return IItemStack.empty();
    }

    @ZenCodeType.Method
    public IItemStack asItemStack() {
        return this.asItemStack(1);
    }

    @ZenCodeType.Method
    public IFluidStack asFluidStack(int amount) {
        IMaterialFormInfo iMaterialFormInfo = this.info;
        if (iMaterialFormInfo instanceof IFluidLike) {
            IFluidLike fluid = (IFluidLike)((Object)iMaterialFormInfo);
            return IFluidStack.of((Object)new FluidStack(fluid.asFluid(), amount));
        }
        return IFluidStack.empty();
    }

    @ZenCodeType.Method
    public Block asBlock() {
        IMaterialFormInfo iMaterialFormInfo = this.info;
        if (iMaterialFormInfo instanceof IBlockLike) {
            IBlockLike block = (IBlockLike)((Object)iMaterialFormInfo);
            return block.asBlock();
        }
        return null;
    }

    @ZenCodeType.Method
    public BlockState asBlockState() {
        IMaterialFormInfo iMaterialFormInfo = this.info;
        if (iMaterialFormInfo instanceof IBlockLike) {
            IBlockLike block = (IBlockLike)((Object)iMaterialFormInfo);
            return block.asBlock().defaultBlockState();
        }
        return null;
    }
}

