/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.actuallyadditions.recipes;

import com.google.gson.JsonElement;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final float outputChance;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondChance;

    public CrushingRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, float outputChance) {
        this(key, input, output, outputCount, outputChance, ItemStack.EMPTY, 0, 0.0f);
    }

    public CrushingRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, float outputChance, Object secondOutput, int secondOutputCount, float secondChance) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.outputChance = outputChance;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondChance = secondChance;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        CrushingRecipe recipe = new CrushingRecipe(ing, stack, this.outputChance, secondStack, this.secondChance);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

