/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import com.google.common.base.Functions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.custom.CustomCodecs;
import thelm.jaopca.api.forms.IFormSettings;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.blocks.BlockFormType;

public class BlockCustomCodecs {
    public static final Codec<IFormSettings> BLOCK_FORM_SETTINGS = CustomCodecs.builder(instance -> RecordCodecBuilder.point((Object)BlockFormType.INSTANCE.getNewSettings())).withField(CustomCodecs.materialMapColorFunction(MapColor.METAL).optionalFieldOf("mapColor"), s -> s.getMapColorFunction(), (s, f) -> s.setMapColorFunction((Function<IMaterial, MapColor>)f)).withField(Codec.BOOL.optionalFieldOf("replaceable"), s -> s.getReplaceable(), (s, f) -> s.setReplaceable((boolean)f)).withField(CustomCodecs.materialSoundTypeFunction(SoundType.METAL).optionalFieldOf("soundType"), s -> s.getSoundTypeFunction(), (s, f) -> s.setSoundTypeFunction((Function<IMaterial, SoundType>)f)).withField(CustomCodecs.materialIntFunction(0).optionalFieldOf("lightValue"), s -> s.getLightValueFunction(), (s, f) -> s.setLightValueFunction((ToIntFunction<IMaterial>)f)).withField(CustomCodecs.materialDoubleFunction(5.0).optionalFieldOf("blockHardness"), s -> s.getBlockHardnessFunction(), (s, f) -> s.setBlockHardnessFunction((ToDoubleFunction<IMaterial>)f)).withField(CustomCodecs.materialDoubleFunction(6.0).optionalFieldOf("explosionResistance"), s -> s.getExplosionResistanceFunction(), (s, f) -> s.setExplosionResistanceFunction((ToDoubleFunction<IMaterial>)f)).withField(CustomCodecs.materialDoubleFunction(0.6).optionalFieldOf("friction"), s -> s.getFrictionFunction(), (s, f) -> s.setFrictionFunction((ToDoubleFunction<IMaterial>)f)).withField(CustomCodecs.VOXEL_SHAPE.optionalFieldOf("shape"), s -> s.getShape(), (s, f) -> s.setShape((VoxelShape)f)).withField(CustomCodecs.VOXEL_SHAPE.optionalFieldOf("interactionShape"), s -> s.getInteractionShape(), (s, f) -> s.setInteractionShape((VoxelShape)f)).withField(CustomCodecs.materialPredicate(false).optionalFieldOf("requiresTool"), s -> s.getRequiresToolFunction(), (s, f) -> s.setRequiresToolFunction((Predicate<IMaterial>)f)).withField(CustomCodecs.materialStringFunction("minecraft:mineable/pickaxe").optionalFieldOf("harvestToolTag"), s -> s.getHarvestToolTagFunction(), (s, f) -> s.setHarvestToolTagFunction((Function<IMaterial, String>)f)).withField(CustomCodecs.materialStringFunction("").optionalFieldOf("harvestTierTag"), s -> s.getHarvestTierTagFunction(), (s, f) -> s.setHarvestTierTagFunction((Function<IMaterial, String>)f)).withField(CustomCodecs.materialIntFunction(0).optionalFieldOf("flammability"), s -> s.getFlammabilityFunction(), (s, f) -> s.setFlammabilityFunction((ToIntFunction<IMaterial>)f)).withField(CustomCodecs.materialIntFunction(0).optionalFieldOf("fireSpreadSpeed"), s -> s.getFireSpreadSpeedFunction(), (s, f) -> s.setFireSpreadSpeedFunction((ToIntFunction<IMaterial>)f)).withField(CustomCodecs.materialPredicate(false).optionalFieldOf("isFireSource"), s -> s.getIsFireSourceFunction(), (s, f) -> s.setIsFireSourceFunction((Predicate<IMaterial>)f)).withField(CustomCodecs.materialEnumFunction(PushReaction.class, PushReaction.NORMAL).optionalFieldOf("pushReaction"), s -> s.getPushReactionFunction(), (s, f) -> s.setPushReactionFunction((Function<IMaterial, PushReaction>)f)).withField(CustomCodecs.materialEnumFunction(NoteBlockInstrument.class, NoteBlockInstrument.HARP).optionalFieldOf("instrument"), s -> s.getInstrumentFunction(), (s, f) -> s.setInstrumentFunction((Function<IMaterial, NoteBlockInstrument>)f)).withField(CustomCodecs.materialIntFunction(64).optionalFieldOf("maxStackSize"), s -> s.getMaxStackSizeFunction(), (s, f) -> s.setMaxStackSizeFunction((ToIntFunction<IMaterial>)f)).withField(CustomCodecs.materialPredicate(false).optionalFieldOf("hasEffect"), s -> s.getHasEffectFunction(), (s, f) -> s.setHasEffectFunction((Predicate<IMaterial>)f)).withField(CustomCodecs.materialEnumFunction(Rarity.class, Rarity.COMMON).optionalFieldOf("rarity"), s -> s.getDisplayRarityFunction(), (s, f) -> s.setDisplayRarityFunction((Function<IMaterial, Rarity>)f)).build().flatComapMap((Function)Functions.identity(), s -> {
        DataResult dataResult;
        if (s instanceof IBlockFormSettings) {
            IBlockFormSettings bs = (IBlockFormSettings)s;
            dataResult = DataResult.success((Object)bs);
        } else {
            dataResult = DataResult.error(() -> "Not block form settings");
        }
        return dataResult;
    });

    private BlockCustomCodecs() {
    }
}

