/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.materials;

import java.util.Arrays;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.lang3.ArrayUtils;

public enum MaterialType implements StringRepresentable
{
    INGOT("ingots"),
    INGOT_LEGACY("ingots"),
    GEM("gems"),
    CRYSTAL("crystals"),
    DUST("dusts"),
    INGOT_PLAIN("ingots"),
    GEM_PLAIN("gems"),
    CRYSTAL_PLAIN("crystals"),
    DUST_PLAIN("dusts");

    public static final MaterialType[] INGOTS;
    public static final MaterialType[] GEMS;
    public static final MaterialType[] CRYSTALS;
    public static final MaterialType[] DUSTS;
    public static final MaterialType[] NON_DUSTS;
    public static final MaterialType[] ORE;
    private final String formName;

    private MaterialType(String formName) {
        this.formName = formName;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.US);
    }

    public String getSerializedName() {
        return this.getName();
    }

    public String getFormName() {
        return this.formName;
    }

    public boolean isIngot() {
        return ArrayUtils.contains((Object[])INGOTS, (Object)((Object)this));
    }

    public boolean isGem() {
        return ArrayUtils.contains((Object[])GEMS, (Object)((Object)this));
    }

    public boolean isCrystal() {
        return ArrayUtils.contains((Object[])CRYSTALS, (Object)((Object)this));
    }

    public boolean isCrystalline() {
        return this.isGem() || this.isCrystal();
    }

    public boolean isDust() {
        return ArrayUtils.contains((Object[])DUSTS, (Object)((Object)this));
    }

    public boolean isOre() {
        return ArrayUtils.contains((Object[])ORE, (Object)((Object)this));
    }

    public static MaterialType fromName(String name) {
        return Arrays.stream(MaterialType.values()).filter(t -> t.getName().equalsIgnoreCase(name)).findAny().orElse(null);
    }

    static {
        INGOTS = new MaterialType[]{INGOT, INGOT_LEGACY, INGOT_PLAIN};
        GEMS = new MaterialType[]{GEM, GEM_PLAIN};
        CRYSTALS = new MaterialType[]{CRYSTAL, CRYSTAL_PLAIN};
        DUSTS = new MaterialType[]{DUST, DUST_PLAIN};
        NON_DUSTS = new MaterialType[]{INGOT, INGOT_LEGACY, GEM, CRYSTAL, INGOT_PLAIN, GEM_PLAIN, CRYSTAL_PLAIN};
        ORE = new MaterialType[]{INGOT, INGOT_LEGACY, GEM, CRYSTAL, DUST};
    }
}

