/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.helpers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public interface IMiscHelper {
    public ResourceLocation createResourceLocation(String var1, String var2);

    public ResourceLocation createResourceLocation(String var1);

    public ResourceLocation getRecipeKey(String var1, String var2);

    public ResourceLocation getTagLocation(String var1, String var2);

    public ResourceLocation getTagLocation(String var1, String var2, String var3);

    public ItemStack getItemStack(Object var1, int var2);

    public Ingredient getIngredient(Object var1);

    public SizedIngredient getSizedIngredient(Object var1, int var2);

    public TagKey<Item> getItemTagKey(ResourceLocation var1);

    public Collection<Item> getItemTagValues(ResourceLocation var1);

    public ItemStack getPreferredItemStack(Iterable<Item> var1, int var2);

    public FluidStack getFluidStack(Object var1, int var2);

    public FluidIngredient getFluidIngredient(Object var1);

    public SizedFluidIngredient getSizedFluidIngredient(Object var1, int var2);

    public TagKey<Fluid> getFluidTagKey(ResourceLocation var1);

    public Collection<Fluid> getFluidTagValues(ResourceLocation var1);

    public FluidStack getPreferredFluidStack(Iterable<Fluid> var1, int var2);

    public <T> Collection<T> getTagValues(ResourceKey<? extends Registry<T>> var1, ResourceLocation var2);

    public <T> Collection<T> getTagValues(ResourceLocation var1, ResourceLocation var2);

    public <T> Optional<T> getPreferredEntry(Function<T, ResourceLocation> var1, Iterable<T> var2);

    public <T> Optional<T> getPreferredEntry(Comparator<T> var1, Function<T, ResourceLocation> var2, Iterable<T> var3);

    public Comparator<Fluid> flowingFluidComparator();

    public <T> Comparator<T> entryPreferenceComparator(Function<T, ResourceLocation> var1);

    public void caclulateMaterialSet(Collection<String> var1, Collection<String> var2);

    public void caclulateModuleSet(Collection<String> var1, Collection<String> var2);

    public Ingredient wrapIngredient(Ingredient var1);

    public JsonElement serializeIngredient(Ingredient var1);

    public JsonObject serializeItemStack(ItemStack var1);

    public JsonObject serializeFluidStack(FluidStack var1);

    public JsonElement serializeRecipe(Recipe<?> var1);

    public <T> JsonElement serialize(Codec<T> var1, T var2);

    public Predicate<String> configMaterialPredicate();

    public Predicate<String> configModulePredicate();

    public Runnable conditionalRunnable(BooleanSupplier var1, Supplier<Runnable> var2, Supplier<Runnable> var3);

    public <T> Supplier<T> conditionalSupplier(BooleanSupplier var1, Supplier<Supplier<T>> var2, Supplier<Supplier<T>> var3);

    public boolean hasResource(ResourceLocation var1);
}

