/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.functions;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.functions.MaterialFunction;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;

public final class MaterialMappedFunction<T>
implements Function<IMaterial, T> {
    public final T defaultValue;
    public final Map<MaterialType, T> materialTypes;
    public final Map<IMaterial, T> materials;
    public final String path;
    public final String comment;
    public final Map<IMaterial, T> configMaterials;
    public final Function<String, T> nameToValue;
    public final Function<T, String> valueToName;

    private MaterialMappedFunction(T defaultValue, Map<MaterialType, T> materialTypes, Map<IMaterial, T> materials, String path, String comment, Function<String, T> nameToValue, Function<T, String> valueToName) {
        this.defaultValue = defaultValue;
        this.materialTypes = Objects.requireNonNull(materialTypes);
        this.materials = Objects.requireNonNull(materials);
        this.path = Strings.nullToEmpty((String)path);
        this.comment = Strings.nullToEmpty((String)comment);
        this.nameToValue = Objects.requireNonNull(nameToValue);
        this.valueToName = Objects.requireNonNull(valueToName);
        this.configMaterials = !path.isEmpty() ? new HashMap() : Map.of();
    }

    public static <T> MaterialMappedFunction<T> of(T defaultValue, Map<MaterialType, T> materialTypes, Map<IMaterial, T> materials, String path, String comment, Function<String, T> nameToValue, Function<T, String> valueToName) {
        return new MaterialMappedFunction<T>(defaultValue, materialTypes, materials, path, comment, nameToValue, valueToName);
    }

    public static <T> MaterialMappedFunction<T> of(T defaultValue, Map<MaterialType, T> materialTypes, Map<IMaterial, T> materials, Function<String, T> nameToValue, Function<T, String> valueToName) {
        return MaterialMappedFunction.of(defaultValue, materialTypes, materials, "", "", nameToValue, valueToName);
    }

    public static <T> MaterialMappedFunction<T> of(T defaultValue, String path, String comment, Function<String, T> nameToValue, Function<T, String> valueToName) {
        return MaterialMappedFunction.of(defaultValue, Map.of(), Map.of(), path, comment, nameToValue, valueToName);
    }

    public static <T> MaterialMappedFunction<T> of(T defaultValue, Function<String, T> nameToValue, Function<T, String> valueToName) {
        return MaterialMappedFunction.of(defaultValue, Map.of(), Map.of(), "", "", nameToValue, valueToName);
    }

    public static <T> MaterialMappedFunction<T> of(T defaultValue, Function<IMaterial, T> function, Function<String, T> nameToValue, Function<T, String> valueToName) {
        if (function instanceof MaterialMappedFunction) {
            MaterialMappedFunction mf = (MaterialMappedFunction)function;
            return MaterialMappedFunction.of(defaultValue, mf.materialTypes, mf.materials, mf.path, mf.comment, nameToValue, valueToName);
        }
        if (function instanceof MaterialFunction) {
            MaterialFunction mf = (MaterialFunction)function;
            return MaterialMappedFunction.of(defaultValue, mf.materialTypes, mf.materials, nameToValue, valueToName);
        }
        Map materialMap = JAOPCAApi.instance().getMaterials().stream().collect(Collectors.toMap(Function.identity(), function::apply));
        return MaterialMappedFunction.of(defaultValue, Map.of(), materialMap, nameToValue, valueToName);
    }

    public static MaterialMappedFunction<String> of(String defaultValue, Map<MaterialType, String> materialTypes, Map<IMaterial, String> materials, String path, String comment) {
        return MaterialMappedFunction.of(defaultValue, materialTypes, materials, path, comment, Function.identity(), Function.identity());
    }

    public static MaterialMappedFunction<String> of(String defaultValue, Map<MaterialType, String> materialTypes, Map<IMaterial, String> materials) {
        return MaterialMappedFunction.of(defaultValue, materialTypes, materials, "", "");
    }

    public static MaterialMappedFunction<String> of(String defaultValue, String path, String comment) {
        return MaterialMappedFunction.of(defaultValue, Map.of(), Map.of(), path, comment);
    }

    public static MaterialMappedFunction<String> of(String defaultValue) {
        return MaterialMappedFunction.of(defaultValue, Map.of(), Map.of(), "", "");
    }

    public static MaterialMappedFunction<String> of(String defaultValue, Function<IMaterial, String> function) {
        if (function instanceof MaterialMappedFunction) {
            MaterialMappedFunction mf = (MaterialMappedFunction)function;
            return MaterialMappedFunction.of(defaultValue, mf.materialTypes, mf.materials, mf.path, mf.comment);
        }
        if (function instanceof MaterialFunction) {
            MaterialFunction mf = (MaterialFunction)function;
            return MaterialMappedFunction.of(defaultValue, mf.materialTypes, mf.materials);
        }
        Map<IMaterial, String> materialMap = JAOPCAApi.instance().getMaterials().stream().collect(Collectors.toMap(Function.identity(), function::apply));
        return MaterialMappedFunction.of(defaultValue, Map.of(), materialMap);
    }

    public static <T extends Enum<T>> MaterialMappedFunction<T> of(Class<T> enumClass, T defaultValue, Map<MaterialType, T> materialTypes, Map<IMaterial, T> materials, String path, String comment) {
        return MaterialMappedFunction.of(defaultValue, materialTypes, materials, path, comment, name -> Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(value -> value.name().equalsIgnoreCase((String)name)).findAny().orElse(null), value -> value == null ? "" : value.name().toLowerCase(Locale.US));
    }

    public static <T extends Enum<T>> MaterialMappedFunction<T> of(Class<T> enumClass, T defaultValue, Map<MaterialType, T> materialTypes, Map<IMaterial, T> materials) {
        return MaterialMappedFunction.of(enumClass, defaultValue, materialTypes, materials, "", "");
    }

    public static <T extends Enum<T>> MaterialMappedFunction<T> of(Class<T> enumClass, T defaultValue, String path, String comment) {
        return MaterialMappedFunction.of(enumClass, defaultValue, Map.of(), Map.of(), path, comment);
    }

    public static <T extends Enum<T>> MaterialMappedFunction<T> of(Class<T> enumClass, T defaultValue) {
        return MaterialMappedFunction.of(enumClass, defaultValue, Map.of(), Map.of(), "", "");
    }

    public static <T extends Enum<T>> MaterialMappedFunction<T> of(Class<T> enumClass, T defaultValue, Function<IMaterial, T> function) {
        if (function instanceof MaterialMappedFunction) {
            MaterialMappedFunction mf = (MaterialMappedFunction)function;
            return MaterialMappedFunction.of(enumClass, defaultValue, mf.materialTypes, mf.materials, mf.path, mf.comment);
        }
        if (function instanceof MaterialFunction) {
            MaterialFunction mf = (MaterialFunction)function;
            return MaterialMappedFunction.of(enumClass, defaultValue, mf.materialTypes, mf.materials);
        }
        Map materialMap = JAOPCAApi.instance().getMaterials().stream().collect(Collectors.toMap(Function.identity(), function::apply));
        return MaterialMappedFunction.of(enumClass, defaultValue, Map.of(), materialMap);
    }

    @Override
    public T apply(IMaterial material) {
        if (!this.path.isEmpty()) {
            return (T)this.configMaterials.computeIfAbsent(material, m -> this.nameToValue.apply(JAOPCAApi.instance().getMaterialConfig(material).getDefinedString(this.path, this.valueToName.apply(this.applyUnconfigured(material)), this.comment)));
        }
        return this.applyUnconfigured(material);
    }

    public T applyUnconfigured(IMaterial material) {
        if (this.materials.containsKey(material)) {
            return this.materials.get(material);
        }
        if (this.materialTypes.containsKey((Object)material.getType())) {
            return this.materialTypes.get((Object)material.getType());
        }
        return this.defaultValue;
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.materialTypes, this.materials, this.path, this.nameToValue, this.valueToName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MaterialMappedFunction) {
            MaterialMappedFunction other = (MaterialMappedFunction)obj;
            return Objects.equals(this.defaultValue, other.defaultValue) && this.materialTypes.equals(other.materialTypes) && this.materials.equals(other.materials) && this.path.equals(other.path) && this.nameToValue.equals(other.nameToValue) && this.valueToName.equals(other.valueToName);
        }
        return false;
    }
}

