/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.functions;

import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;

public final class MaterialIntFunction
implements ToIntFunction<IMaterial> {
    public final int defaultValue;
    public final Object2IntMap<MaterialType> materialTypes;
    public final Object2IntMap<IMaterial> materials;
    public final String path;
    public final String comment;
    public final Object2IntMap<IMaterial> configMaterials;

    private MaterialIntFunction(int defaultValue, Object2IntMap<MaterialType> materialTypes, Object2IntMap<IMaterial> materials, String path, String comment) {
        this.defaultValue = defaultValue;
        this.materialTypes = Objects.requireNonNull(materialTypes);
        this.materials = Objects.requireNonNull(materials);
        this.path = Strings.nullToEmpty((String)path);
        this.comment = Strings.nullToEmpty((String)comment);
        this.configMaterials = !path.isEmpty() ? new Object2IntOpenHashMap() : Object2IntMaps.emptyMap();
    }

    public static MaterialIntFunction of(int defaultValue, Object2IntMap<MaterialType> materialTypes, Object2IntMap<IMaterial> materials, String path, String comment) {
        return new MaterialIntFunction(defaultValue, materialTypes, materials, path, comment);
    }

    public static MaterialIntFunction of(int defaultValue, Object2IntMap<MaterialType> materialTypes, Object2IntMap<IMaterial> materials) {
        return MaterialIntFunction.of(defaultValue, materialTypes, materials, "", "");
    }

    public static MaterialIntFunction of(int defaultValue, String path, String comment) {
        return MaterialIntFunction.of(defaultValue, (Object2IntMap<MaterialType>)Object2IntMaps.emptyMap(), (Object2IntMap<IMaterial>)Object2IntMaps.emptyMap(), path, comment);
    }

    public static MaterialIntFunction of(int defaultValue) {
        return MaterialIntFunction.of(defaultValue, (Object2IntMap<MaterialType>)Object2IntMaps.emptyMap(), (Object2IntMap<IMaterial>)Object2IntMaps.emptyMap(), "", "");
    }

    public static MaterialIntFunction of(int defaultValue, ToIntFunction<IMaterial> function) {
        if (function instanceof MaterialIntFunction) {
            MaterialIntFunction mf = (MaterialIntFunction)function;
            return MaterialIntFunction.of(defaultValue, mf.materialTypes, mf.materials, mf.path, mf.comment);
        }
        Object2IntMap materialMap = (Object2IntMap)JAOPCAApi.instance().getMaterials().stream().collect(Collectors.toMap(Function.identity(), function::applyAsInt, (a, b) -> a, Object2IntOpenHashMap::new));
        return MaterialIntFunction.of(defaultValue, (Object2IntMap<MaterialType>)Object2IntMaps.emptyMap(), (Object2IntMap<IMaterial>)materialMap, "", "");
    }

    @Override
    public int applyAsInt(IMaterial material) {
        if (!this.path.isEmpty()) {
            return this.configMaterials.computeIfAbsent((Object)material, m -> JAOPCAApi.instance().getMaterialConfig(material).getDefinedInt(this.path, this.applyAsIntUnconfigured(material), this.comment));
        }
        return this.applyAsIntUnconfigured(material);
    }

    public int applyAsIntUnconfigured(IMaterial material) {
        if (this.materials.containsKey((Object)material)) {
            return this.materials.getInt((Object)material);
        }
        if (this.materialTypes.containsKey((Object)material.getType())) {
            return this.materialTypes.getInt((Object)material.getType());
        }
        return this.defaultValue;
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.materialTypes, this.materials, this.path);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MaterialIntFunction) {
            MaterialIntFunction other = (MaterialIntFunction)obj;
            return this.defaultValue == other.defaultValue && this.materialTypes.equals(other.materialTypes) && this.materials.equals(other.materials) && this.path.equals(other.path);
        }
        return false;
    }
}

