/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.functions;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.functions.MaterialMappedFunction;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;

public final class MaterialFunction<T>
implements Function<IMaterial, T> {
    public final T defaultValue;
    public final Map<MaterialType, T> materialTypes;
    public final Map<IMaterial, T> materials;

    private MaterialFunction(T defaultValue, Map<MaterialType, T> materialTypes, Map<IMaterial, T> materials) {
        this.defaultValue = defaultValue;
        this.materialTypes = Objects.requireNonNull(materialTypes);
        this.materials = Objects.requireNonNull(materials);
    }

    public static <T> MaterialFunction<T> of(T defaultValue, Map<MaterialType, T> materialTypes, Map<IMaterial, T> materials) {
        return new MaterialFunction<T>(defaultValue, materialTypes, materials);
    }

    public static <T> MaterialFunction<T> of(T defaultValue) {
        return MaterialFunction.of(defaultValue, Map.of(), Map.of());
    }

    public static <T> MaterialFunction<T> of(T defaultValue, Function<IMaterial, T> function) {
        if (function instanceof MaterialFunction) {
            MaterialFunction mf = (MaterialFunction)function;
            return MaterialFunction.of(defaultValue, mf.materialTypes, mf.materials);
        }
        if (function instanceof MaterialMappedFunction) {
            MaterialMappedFunction mf = (MaterialMappedFunction)function;
            return MaterialFunction.of(defaultValue, mf.materialTypes, mf.materials);
        }
        Map materialMap = JAOPCAApi.instance().getMaterials().stream().collect(Collectors.toMap(Function.identity(), function::apply));
        return MaterialFunction.of(defaultValue, Map.of(), materialMap);
    }

    @Override
    public T apply(IMaterial material) {
        if (this.materials.containsKey(material)) {
            return this.materials.get(material);
        }
        if (this.materialTypes.containsKey((Object)material.getType())) {
            return this.materialTypes.get((Object)material.getType());
        }
        return this.defaultValue;
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.materialTypes, this.materials);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MaterialFunction) {
            MaterialFunction other = (MaterialFunction)obj;
            return Objects.equals(this.defaultValue, other.defaultValue) && this.materialTypes.equals(other.materialTypes) && this.materials.equals(other.materials);
        }
        return false;
    }
}

