/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.custom;

import com.google.common.base.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMaps;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import net.neoforged.neoforge.registries.DeferredHolder;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.custom.BuilderCodecBuilder;
import thelm.jaopca.api.custom.MapColorType;
import thelm.jaopca.api.custom.VanillaSoundType;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.functions.MaterialDoubleFunction;
import thelm.jaopca.api.functions.MaterialFunction;
import thelm.jaopca.api.functions.MaterialIntFunction;
import thelm.jaopca.api.functions.MaterialLongFunction;
import thelm.jaopca.api.functions.MaterialMappedFunction;
import thelm.jaopca.api.functions.MaterialPredicate;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.mixins.DeferredSoundTypeAccessor;

public class CustomCodecs {
    public static final Codec<MaterialType> MATERIAL_TYPE = StringRepresentable.fromValues(MaterialType::values);
    public static final Codec<IMaterial> MATERIAL = Codec.STRING.comapFlatMap(DataResult.partialGet(JAOPCAApi.instance()::getMaterial, () -> "Unknown material "), IMaterial::getName);
    public static final Codec<IFormType> FORM_TYPE = Codec.STRING.comapFlatMap(DataResult.partialGet(JAOPCAApi.instance()::getFormType, () -> "Unknown form type "), IFormType::getName);
    public static final Codec<MapColor> MAP_COLOR = StringRepresentable.fromValues(MapColorType::values).xmap(MapColorType::toMapColor, MapColorType::fromMapColor);
    public static final Codec<SoundType> VANILLA_SOUND_TYPE = StringRepresentable.fromValues(VanillaSoundType::values).xmap(VanillaSoundType::toSoundType, VanillaSoundType::fromSoundType);
    public static final Codec<DeferredSoundType> DEFERRED_SOUND_TYPE = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("volume").forGetter(SoundType::getVolume), (App)Codec.FLOAT.fieldOf("pitch").forGetter(SoundType::getPitch), (App)CustomCodecs.deferredHolderSupplier(Registries.SOUND_EVENT).fieldOf("break").forGetter(st -> ((DeferredSoundTypeAccessor)st).breakSound()), (App)CustomCodecs.deferredHolderSupplier(Registries.SOUND_EVENT).fieldOf("step").forGetter(st -> ((DeferredSoundTypeAccessor)st).stepSound()), (App)CustomCodecs.deferredHolderSupplier(Registries.SOUND_EVENT).fieldOf("place").forGetter(st -> ((DeferredSoundTypeAccessor)st).placeSound()), (App)CustomCodecs.deferredHolderSupplier(Registries.SOUND_EVENT).fieldOf("hit").forGetter(st -> ((DeferredSoundTypeAccessor)st).hitSound()), (App)CustomCodecs.deferredHolderSupplier(Registries.SOUND_EVENT).fieldOf("fall").forGetter(st -> ((DeferredSoundTypeAccessor)st).fallSound())).apply((Applicative)instance, DeferredSoundType::new));
    public static final Codec<SoundType> SOUND_TYPE = Codec.either(VANILLA_SOUND_TYPE, DEFERRED_SOUND_TYPE).xmap(CustomCodecs.eitherIdentity(), st -> {
        Either either;
        if (st instanceof DeferredSoundType) {
            DeferredSoundType dst = (DeferredSoundType)st;
            either = Either.right((Object)dst);
        } else {
            either = Either.left((Object)st);
        }
        return either;
    });
    public static final Codec<AABB> AABB = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.fieldOf("from").forGetter(aabb -> new Vec3(aabb.minX, aabb.minY, aabb.minZ)), (App)Vec3.CODEC.fieldOf("to").forGetter(aabb -> new Vec3(aabb.maxX, aabb.maxY, aabb.maxZ))).apply((Applicative)instance, AABB::new));
    public static final Codec<VoxelShape> VOXEL_SHAPE = CustomCodecs.listOrSingle(AABB).xmap(aabbs -> aabbs.stream().map(Shapes::create).reduce(Shapes.empty(), Shapes::or), VoxelShape::toAabbs);

    private CustomCodecs() {
    }

    public static <T> Function<Either<? extends T, ? extends T>, T> eitherIdentity() {
        return either -> either.map(Function.identity(), Function.identity());
    }

    public static <T> Codec<Collection<T>> collectionOf(Codec<T> codec) {
        return codec.listOf().xmap(Function.identity(), List::copyOf);
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> codec) {
        return codec.listOf().xmap(Set::copyOf, List::copyOf);
    }

    public static <T> Codec<List<T>> listOrSingle(Codec<T> codec) {
        return Codec.either((Codec)codec.listOf(), codec).xmap(either -> (List)either.map(Function.identity(), List::of), Either::left);
    }

    public static <T extends Enum<T>> Codec<T> enumByName(Class<T> enumClass) {
        return Codec.STRING.comapFlatMap(DataResult.partialGet(name -> Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(value -> value.name().equalsIgnoreCase((String)name)).findAny().orElse(null), () -> "Unknown enum "), value -> value.name().toLowerCase(Locale.US));
    }

    public static <T> Codec<Object2BooleanMap<T>> obj2BoolMap(Codec<T> codec) {
        return Codec.unboundedMap(codec, (Codec)Codec.BOOL).xmap(Object2BooleanOpenHashMap::new, Object2BooleanOpenHashMap::new);
    }

    public static <T> Codec<Object2IntMap<T>> obj2IntMap(Codec<T> codec) {
        return Codec.unboundedMap(codec, (Codec)Codec.INT).xmap(Object2IntOpenHashMap::new, Object2IntOpenHashMap::new);
    }

    public static <T> Codec<Object2DoubleMap<T>> obj2DoubleMap(Codec<T> codec) {
        return Codec.unboundedMap(codec, (Codec)Codec.DOUBLE).xmap(Object2DoubleOpenHashMap::new, Object2DoubleOpenHashMap::new);
    }

    public static <T> Codec<Object2LongMap<T>> obj2LongMap(Codec<T> codec) {
        return Codec.unboundedMap(codec, (Codec)Codec.LONG).xmap(Object2LongOpenHashMap::new, Object2LongOpenHashMap::new);
    }

    public static final <O> BuilderCodecBuilder<O> builder(Function<RecordCodecBuilder.Instance<O>, App<RecordCodecBuilder.Mu<O>, O>> base) {
        return BuilderCodecBuilder.of(base);
    }

    public static <R, T extends R> Codec<DeferredHolder<R, T>> deferredHolder(ResourceKey<? extends Registry<R>> registry) {
        return ResourceKey.codec(registry).xmap(DeferredHolder::create, DeferredHolder::getKey);
    }

    public static <R> Codec<Supplier<R>> deferredHolderSupplier(ResourceKey<? extends Registry<R>> registry) {
        return CustomCodecs.deferredHolder(registry).xmap(Function.identity(), supplier -> {
            if (supplier instanceof DeferredHolder) {
                return (DeferredHolder)supplier;
            }
            return DeferredHolder.create((ResourceKey)registry, (ResourceLocation)((Registry)BuiltInRegistries.REGISTRY.get(registry.registry())).getKey(supplier.get()));
        });
    }

    public static Codec<Predicate<IMaterial>> materialPredicate(boolean defaultValue) {
        return Codec.either((Codec)Codec.BOOL, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("default", (Object)defaultValue).forGetter(f -> f.defaultValue), (App)CustomCodecs.obj2BoolMap(MATERIAL_TYPE).optionalFieldOf("materialTypes", (Object)Object2BooleanMaps.emptyMap()).forGetter(f -> f.materialTypes), (App)CustomCodecs.obj2BoolMap(MATERIAL).optionalFieldOf("materials", (Object)Object2BooleanMaps.emptyMap()).forGetter(f -> f.materials), (App)Codec.STRING.optionalFieldOf("path", (Object)"").forGetter(f -> f.path), (App)Codec.STRING.optionalFieldOf("comment", (Object)"").forGetter(f -> f.comment)).apply((Applicative)instance, MaterialPredicate::of))).xmap(either -> (MaterialPredicate)either.map(MaterialPredicate::of, (Function)Functions.identity()), Either::right).xmap(Function.identity(), f -> MaterialPredicate.of(defaultValue, f));
    }

    public static Codec<ToIntFunction<IMaterial>> materialIntFunction(int defaultValue) {
        return Codec.either((Codec)Codec.INT, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("default", (Object)defaultValue).forGetter(f -> f.defaultValue), (App)CustomCodecs.obj2IntMap(MATERIAL_TYPE).optionalFieldOf("materialTypes", (Object)Object2IntMaps.emptyMap()).forGetter(f -> f.materialTypes), (App)CustomCodecs.obj2IntMap(MATERIAL).optionalFieldOf("materials", (Object)Object2IntMaps.emptyMap()).forGetter(f -> f.materials), (App)Codec.STRING.optionalFieldOf("path", (Object)"").forGetter(f -> f.path), (App)Codec.STRING.optionalFieldOf("comment", (Object)"").forGetter(f -> f.comment)).apply((Applicative)instance, MaterialIntFunction::of))).xmap(either -> (MaterialIntFunction)either.map(MaterialIntFunction::of, (Function)Functions.identity()), Either::right).xmap(Function.identity(), f -> MaterialIntFunction.of(defaultValue, f));
    }

    public static Codec<ToDoubleFunction<IMaterial>> materialDoubleFunction(double defaultValue) {
        return Codec.either((Codec)Codec.DOUBLE, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("default", (Object)defaultValue).forGetter(f -> f.defaultValue), (App)CustomCodecs.obj2DoubleMap(MATERIAL_TYPE).optionalFieldOf("materialTypes", (Object)Object2DoubleMaps.emptyMap()).forGetter(f -> f.materialTypes), (App)CustomCodecs.obj2DoubleMap(MATERIAL).optionalFieldOf("materials", (Object)Object2DoubleMaps.emptyMap()).forGetter(f -> f.materials), (App)Codec.STRING.optionalFieldOf("path", (Object)"").forGetter(f -> f.path), (App)Codec.STRING.optionalFieldOf("comment", (Object)"").forGetter(f -> f.comment)).apply((Applicative)instance, MaterialDoubleFunction::of))).xmap(either -> (MaterialDoubleFunction)either.map(MaterialDoubleFunction::of, (Function)Functions.identity()), Either::right).xmap(Function.identity(), f -> MaterialDoubleFunction.of(defaultValue, f));
    }

    public static Codec<ToLongFunction<IMaterial>> materialLongFunction(long defaultValue) {
        return Codec.either((Codec)Codec.LONG, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("default", (Object)defaultValue).forGetter(f -> f.defaultValue), (App)CustomCodecs.obj2LongMap(MATERIAL_TYPE).optionalFieldOf("materialTypes", (Object)Object2LongMaps.emptyMap()).forGetter(f -> f.materialTypes), (App)CustomCodecs.obj2LongMap(MATERIAL).optionalFieldOf("materials", (Object)Object2LongMaps.emptyMap()).forGetter(f -> f.materials), (App)Codec.STRING.optionalFieldOf("path", (Object)"").forGetter(f -> f.path), (App)Codec.STRING.optionalFieldOf("comment", (Object)"").forGetter(f -> f.comment)).apply((Applicative)instance, MaterialLongFunction::of))).xmap(either -> (MaterialLongFunction)either.map(MaterialLongFunction::of, (Function)Functions.identity()), Either::right).xmap(Function.identity(), f -> MaterialLongFunction.of(defaultValue, f));
    }

    public static <T> Codec<Function<IMaterial, T>> materialMappedFunction(Function<String, T> nameToValue, Function<T, String> valueToName, T defaultValue) {
        return Codec.either((Codec)Codec.STRING.xmap(nameToValue, valueToName), (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(nameToValue, valueToName).optionalFieldOf("default", defaultValue).forGetter(f -> f.defaultValue), (App)Codec.unboundedMap(MATERIAL_TYPE, (Codec)Codec.STRING.xmap(nameToValue, valueToName)).optionalFieldOf("materialTypes", Map.of()).forGetter(f -> f.materialTypes), (App)Codec.unboundedMap(MATERIAL, (Codec)Codec.STRING.xmap(nameToValue, valueToName)).optionalFieldOf("materials", Map.of()).forGetter(f -> f.materials), (App)Codec.STRING.optionalFieldOf("path", (Object)"").forGetter(f -> f.path), (App)Codec.STRING.optionalFieldOf("comment", (Object)"").forGetter(f -> f.comment), (App)Codec.unit((Object)nameToValue).fieldOf("nameToValue").forGetter(f -> f.nameToValue), (App)Codec.unit((Object)valueToName).fieldOf("valueToName").forGetter(f -> f.valueToName)).apply((Applicative)instance, MaterialMappedFunction::of))).xmap(either -> (MaterialMappedFunction)either.map(v -> MaterialMappedFunction.of(v, nameToValue, valueToName), (Function)Functions.identity()), Either::right).xmap(Function.identity(), f -> MaterialMappedFunction.of(defaultValue, f, nameToValue, valueToName));
    }

    public static Codec<Function<IMaterial, String>> materialStringFunction(String defaultValue) {
        return CustomCodecs.materialMappedFunction(Function.identity(), Function.identity(), defaultValue);
    }

    public static <T extends Enum<T>> Codec<Function<IMaterial, T>> materialEnumFunction(Class<T> enumClass, T defaultValue) {
        return CustomCodecs.materialMappedFunction(name -> Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(value -> value.name().equalsIgnoreCase((String)name)).findAny().orElse(null), value -> value == null ? "" : value.name().toLowerCase(Locale.US), defaultValue);
    }

    public static <T> Codec<Function<IMaterial, T>> materialFunction(Codec<T> codec, T defaultValue) {
        return Codec.either(codec, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)codec.optionalFieldOf("default", defaultValue).forGetter(f -> f.defaultValue), (App)Codec.unboundedMap(MATERIAL_TYPE, (Codec)codec).optionalFieldOf("materialTypes", Map.of()).forGetter(f -> f.materialTypes), (App)Codec.unboundedMap(MATERIAL, (Codec)codec).optionalFieldOf("materials", Map.of()).forGetter(f -> f.materials)).apply((Applicative)instance, MaterialFunction::of))).xmap(either -> (MaterialFunction)either.map(MaterialFunction::of, (Function)Functions.identity()), Either::right).xmap(Function.identity(), f -> MaterialFunction.of(defaultValue, f));
    }

    public static Codec<Function<IMaterial, MapColor>> materialMapColorFunction(MapColor defaultValue) {
        return CustomCodecs.materialMappedFunction(MapColorType::nameToMapColor, MapColorType::mapColorToName, defaultValue);
    }

    public static Codec<Function<IMaterial, SoundType>> materialSoundTypeFunction(SoundType defaultValue) {
        return CustomCodecs.materialFunction(SOUND_TYPE, defaultValue);
    }
}

