/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.features;

import com.shynieke.geore.modifier.AddConfigFeatureBiomeModifier;
import com.shynieke.geore.registry.GeOreBlockReg;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class GeOreFeatureReg {
    protected final String NAME;
    protected final Block BLOCK;
    protected final Block BUDDING;
    protected final ResourceKey<ConfiguredFeature<?, ?>> GEODE_CONFIGURED_KEY;
    protected final ResourceKey<PlacedFeature> GEODE_PLACEMENT_KEY;

    public String getName() {
        return this.NAME;
    }

    public GeOreFeatureReg(String name, GeOreBlockReg blockReg) {
        this.NAME = name;
        this.BLOCK = (Block)blockReg.getBlock().get();
        this.BUDDING = (Block)blockReg.getBudding().get();
        this.GEODE_CONFIGURED_KEY = GeOreFeatureReg.createConfiguredKey(name + "_geode");
        this.GEODE_PLACEMENT_KEY = GeOreFeatureReg.createPlacedKey(name + "_geode");
    }

    public void setupConfigured(BootstrapContext<ConfiguredFeature<?, ?>> context, GeOreBlockReg blockReg) {
        FeatureUtils.register(context, this.GEODE_CONFIGURED_KEY, (Feature)Feature.GEODE, (FeatureConfiguration)new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.AIR), (BlockStateProvider)SimpleStateProvider.simple((Block)this.BLOCK), (BlockStateProvider)SimpleStateProvider.simple((Block)this.BUDDING), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.CALCITE), (BlockStateProvider)SimpleStateProvider.simple((Block)Blocks.SMOOTH_BASALT), List.of(((AmethystClusterBlock)blockReg.getSmallBud().get()).defaultBlockState(), ((AmethystClusterBlock)blockReg.getMediumBud().get()).defaultBlockState(), ((AmethystClusterBlock)blockReg.getLargeBud().get()).defaultBlockState(), ((AmethystClusterBlock)blockReg.getCluster().get()).defaultBlockState()), BlockTags.FEATURES_CANNOT_REPLACE, BlockTags.GEODE_INVALID_BLOCKS), new GeodeLayerSettings(1.7, 2.2, 3.2, 4.2), new GeodeCrackSettings(0.95, 2.0, 2), 0.35, 0.083, true, (IntProvider)UniformInt.of((int)4, (int)6), (IntProvider)UniformInt.of((int)3, (int)4), (IntProvider)UniformInt.of((int)1, (int)2), -16, 16, 0.05, 1));
    }

    public void setupPlaced(BootstrapContext<PlacedFeature> context, int rarity, int aboveBottom, int absolute) {
        HolderGetter holdergetter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference geodeHolder = holdergetter.getOrThrow(this.GEODE_CONFIGURED_KEY);
        PlacementUtils.register(context, this.GEODE_PLACEMENT_KEY, (Holder)geodeHolder, (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)aboveBottom), (VerticalAnchor)VerticalAnchor.absolute((int)absolute)), BiomeFilter.biome()});
    }

    public void setupBiomeModifier(BootstrapContext<BiomeModifier> context, TagKey<Biome> tag, String configName) {
        HolderGetter biomeHolderGetter = context.lookup(Registries.BIOME);
        HolderGetter placedHolderGetter = context.lookup(Registries.PLACED_FEATURE);
        AddConfigFeatureBiomeModifier addGeore = new AddConfigFeatureBiomeModifier((HolderSet<Biome>)biomeHolderGetter.getOrThrow(tag), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedHolderGetter.getOrThrow(this.GEODE_PLACEMENT_KEY)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS, configName);
        context.register(this.createModifierKey(configName + "_geode"), (Object)addGeore);
    }

    private ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"geore", (String)name));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createConfiguredKey(String path) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"geore", (String)path));
    }

    public static ResourceKey<PlacedFeature> createPlacedKey(String path) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"geore", (String)path));
    }
}

