/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen;

import com.shynieke.geore.block.BuddingGeoreBlock;
import com.shynieke.geore.features.GeOreConfiguredFeatures;
import com.shynieke.geore.features.GeOreFeatures;
import com.shynieke.geore.features.GeOrePlacedFeatures;
import com.shynieke.geore.item.GeoreSpyglassItem;
import com.shynieke.geore.registry.GeOreBlockReg;
import com.shynieke.geore.registry.GeOreRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Cloner;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GeOreDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput, lookupProvider));
            GeoreBlockTags blockTagsProvider = new GeoreBlockTags(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
            generator.addProvider(event.includeServer(), (DataProvider)new GeoreItemTags(packOutput, lookupProvider, blockTagsProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(GeOreDatagen::getProvider), Set.of("geore")));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new Language(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(packOutput, helper));
        }
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.CONFIGURED_FEATURE, GeOreConfiguredFeatures::bootstrap);
        registryBuilder.add(Registries.PLACED_FEATURE, GeOrePlacedFeatures::bootstrap);
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            GeOreFeatures.COAL_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "coal");
            GeOreFeatures.COPPER_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "copper");
            GeOreFeatures.DIAMOND_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "diamond");
            GeOreFeatures.EMERALD_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "emerald");
            GeOreFeatures.GOLD_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "gold");
            GeOreFeatures.IRON_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "iron");
            GeOreFeatures.LAPIS_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "lapis");
            GeOreFeatures.QUARTZ_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "quartz");
            GeOreFeatures.QUARTZ_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_NETHER, "quartz_nether");
            GeOreFeatures.REDSTONE_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "redstone");
            GeOreFeatures.RUBY_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "ruby");
            GeOreFeatures.SAPPHIRE_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "sapphire");
            GeOreFeatures.TOPAZ_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "topaz");
            GeOreFeatures.ZINC_GEORE.setupBiomeModifier((BootstrapContext<BiomeModifier>)context, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, "zinc");
        });
        registryBuilder.add(Registries.BIOME, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(p_311524_ -> p_311524_.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(GeOreBlockTables::new, LootContextParamSets.BLOCK)), lookupProvider);
        }

        protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
            super.validate(writableregistry, validationcontext, problemreporter$collector);
        }

        public static class GeOreBlockTables
        extends BlockLootSubProvider {
            private final HolderLookup.RegistryLookup<Enchantment> enchantmentLookup;

            protected GeOreBlockTables(HolderLookup.Provider lookupProvider) {
                super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
                this.enchantmentLookup = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT);
            }

            protected void generate() {
                this.addGeOreTables(GeOreRegistry.COAL_GEORE);
                this.addGeOreTables(GeOreRegistry.COPPER_GEORE);
                this.addGeOreTables(GeOreRegistry.DIAMOND_GEORE);
                this.addGeOreTables(GeOreRegistry.EMERALD_GEORE);
                this.addGeOreTables(GeOreRegistry.GOLD_GEORE);
                this.addGeOreTables(GeOreRegistry.IRON_GEORE);
                this.addGeOreTables(GeOreRegistry.LAPIS_GEORE);
                this.addGeOreTables(GeOreRegistry.QUARTZ_GEORE);
                this.addGeOreTables(GeOreRegistry.REDSTONE_GEORE);
                this.addGeOreTables(GeOreRegistry.RUBY_GEORE);
                this.addGeOreTables(GeOreRegistry.SAPPHIRE_GEORE);
                this.addGeOreTables(GeOreRegistry.TOPAZ_GEORE);
                this.addGeOreTables(GeOreRegistry.ZINC_GEORE);
            }

            protected void addGeOreTables(GeOreBlockReg blockReg) {
                this.dropSelf((Block)blockReg.getBlock().get());
                this.add((Block)blockReg.getCluster().get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)blockReg.getShard().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.enchantmentLookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)blockReg.getShard().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
                this.dropWhenSilkTouch((Block)blockReg.getSmallBud().get());
                this.dropWhenSilkTouch((Block)blockReg.getMediumBud().get());
                this.dropWhenSilkTouch((Block)blockReg.getLargeBud().get());
                this.add((Block)blockReg.getBudding().get(), GeOreBlockTables.noDrop());
            }

            protected Iterable<Block> getKnownBlocks() {
                return GeOreRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
            }
        }
    }

    public static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput recipeOutput) {
            this.generateRecipes(GeOreRegistry.COAL_GEORE, recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.TORCH, (int)2).pattern("X").pattern("#").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)GeOreRegistry.COAL_GEORE.getShard().get()).unlockedBy("has_coal_geore_shard", Recipes.has((ItemLike)((ItemLike)GeOreRegistry.COAL_GEORE.getShard().get()))).save(recipeOutput, "geore:torch_from_coal_shard");
            this.generateRecipes(GeOreRegistry.COPPER_GEORE, recipeOutput);
            this.smeltToOre(GeOreRegistry.COPPER_GEORE, 0.7f, Items.COPPER_INGOT, recipeOutput);
            this.generateRecipes(GeOreRegistry.DIAMOND_GEORE, recipeOutput);
            this.smeltToOre(GeOreRegistry.DIAMOND_GEORE, 1.0f, Items.DIAMOND, recipeOutput);
            this.generateRecipes(GeOreRegistry.EMERALD_GEORE, recipeOutput);
            this.smeltToOre(GeOreRegistry.EMERALD_GEORE, 1.0f, Items.EMERALD, recipeOutput);
            this.generateRecipes(GeOreRegistry.GOLD_GEORE, recipeOutput);
            this.smeltToOre(GeOreRegistry.GOLD_GEORE, 1.0f, Items.GOLD_INGOT, recipeOutput);
            this.generateRecipes(GeOreRegistry.IRON_GEORE, recipeOutput);
            this.smeltToOre(GeOreRegistry.IRON_GEORE, 0.7f, Items.IRON_INGOT, recipeOutput);
            this.generateRecipes(GeOreRegistry.LAPIS_GEORE, recipeOutput);
            this.smeltToOre(GeOreRegistry.LAPIS_GEORE, 0.2f, Items.LAPIS_LAZULI, recipeOutput);
            this.generateRecipes(GeOreRegistry.QUARTZ_GEORE, recipeOutput);
            this.smeltToOre(GeOreRegistry.QUARTZ_GEORE, 0.2f, Items.QUARTZ, recipeOutput);
            this.generateRecipes(GeOreRegistry.REDSTONE_GEORE, recipeOutput);
            this.smeltToOre(GeOreRegistry.REDSTONE_GEORE, 0.7f, Items.REDSTONE, recipeOutput);
            String gemsID = "gemsandcrystals";
            Item rubyItem = this.getModItem(ResourceLocation.fromNamespaceAndPath((String)gemsID, (String)"ruby"));
            this.generateRecipes(GeOreRegistry.RUBY_GEORE, recipeOutput);
            if (rubyItem != null) {
                this.optionalSmeltToOre(GeOreRegistry.RUBY_GEORE, 0.7f, rubyItem, gemsID, recipeOutput);
            }
            Item sapphireItem = this.getModItem(ResourceLocation.fromNamespaceAndPath((String)gemsID, (String)"sapphire"));
            this.generateRecipes(GeOreRegistry.SAPPHIRE_GEORE, recipeOutput);
            if (sapphireItem != null) {
                this.optionalSmeltToOre(GeOreRegistry.SAPPHIRE_GEORE, 0.7f, sapphireItem, gemsID, recipeOutput);
            }
            Item topazItem = this.getModItem(ResourceLocation.fromNamespaceAndPath((String)gemsID, (String)"topaz"));
            this.generateRecipes(GeOreRegistry.TOPAZ_GEORE, recipeOutput);
            if (topazItem != null) {
                this.optionalSmeltToOre(GeOreRegistry.TOPAZ_GEORE, 0.7f, topazItem, gemsID, recipeOutput);
            }
            this.generateRecipes(GeOreRegistry.ZINC_GEORE, recipeOutput);
        }

        public Item getModItem(ResourceLocation itemLocation) {
            for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
                if (!BuiltInRegistries.ITEM.getKey((Object)item).equals((Object)itemLocation)) continue;
                return item;
            }
            return null;
        }

        private void generateRecipes(GeOreBlockReg blockReg, RecipeOutput recipeConsumer) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockReg.getBlock().get())).define(Character.valueOf('S'), (ItemLike)blockReg.getShard().get()).pattern("SS").pattern("SS").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(recipeConsumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)blockReg.getSpyglass().get())).define(Character.valueOf('#'), (ItemLike)blockReg.getShard().get()).define(Character.valueOf('X'), (ItemLike)Items.COPPER_INGOT).pattern(" # ").pattern(" X ").pattern(" X ").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(recipeConsumer);
        }

        private void smeltToOre(GeOreBlockReg blockReg, float xp, Item item, RecipeOutput recipeConsumer) {
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)xp, (int)200).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(recipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"geore", (String)(BuiltInRegistries.ITEM.getKey((Object)item).getPath() + "_from_smelting_" + blockReg.getShard().getId().getPath())));
            SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)xp, (int)100).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(recipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"geore", (String)(BuiltInRegistries.ITEM.getKey((Object)item).getPath() + "_from_blasting_" + blockReg.getShard().getId().getPath())));
        }

        private void optionalSmeltToOre(GeOreBlockReg blockReg, float xp, Item item, String modid, RecipeOutput recipeConsumer) {
            RecipeOutput conditionalConsumer = recipeConsumer.withConditions(new ICondition[]{new ModLoadedCondition(modid)});
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)xp, (int)200).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(conditionalConsumer, ResourceLocation.fromNamespaceAndPath((String)"geore", (String)(BuiltInRegistries.ITEM.getKey((Object)item).getPath() + "_from_smelting_" + blockReg.getShard().getId().getPath())));
            SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)xp, (int)100).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(conditionalConsumer, ResourceLocation.fromNamespaceAndPath((String)"geore", (String)(BuiltInRegistries.ITEM.getKey((Object)item).getPath() + "_from_blasting_" + blockReg.getShard().getId().getPath())));
        }
    }

    public static class GeoreBlockTags
    extends BlockTagsProvider {
        public GeoreBlockTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, "geore", existingFileHelper);
        }

        private static TagKey<Block> modTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"geore", (String)name));
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(Tags.Blocks.RELOCATION_NOT_SUPPORTED).add((Object)((Block)GeOreRegistry.COAL_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.COPPER_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.DIAMOND_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.EMERALD_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.GOLD_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.IRON_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.LAPIS_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.QUARTZ_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.REDSTONE_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.RUBY_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.SAPPHIRE_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.TOPAZ_GEORE.getBudding().get()));
            this.addMineable(GeOreRegistry.COAL_GEORE);
            this.addMineable(GeOreRegistry.COPPER_GEORE);
            this.addMineable(GeOreRegistry.DIAMOND_GEORE);
            this.addMineable(GeOreRegistry.EMERALD_GEORE);
            this.addMineable(GeOreRegistry.GOLD_GEORE);
            this.addMineable(GeOreRegistry.IRON_GEORE);
            this.addMineable(GeOreRegistry.LAPIS_GEORE);
            this.addMineable(GeOreRegistry.QUARTZ_GEORE);
            this.addMineable(GeOreRegistry.REDSTONE_GEORE);
            this.addMineable(GeOreRegistry.RUBY_GEORE);
            this.addMineable(GeOreRegistry.SAPPHIRE_GEORE);
            this.addMineable(GeOreRegistry.TOPAZ_GEORE);
            this.addMineable(GeOreRegistry.ZINC_GEORE);
            this.addCrystalSounds(GeOreRegistry.COAL_GEORE);
            this.addCrystalSounds(GeOreRegistry.COPPER_GEORE);
            this.addCrystalSounds(GeOreRegistry.DIAMOND_GEORE);
            this.addCrystalSounds(GeOreRegistry.EMERALD_GEORE);
            this.addCrystalSounds(GeOreRegistry.GOLD_GEORE);
            this.addCrystalSounds(GeOreRegistry.IRON_GEORE);
            this.addCrystalSounds(GeOreRegistry.LAPIS_GEORE);
            this.addCrystalSounds(GeOreRegistry.QUARTZ_GEORE);
            this.addCrystalSounds(GeOreRegistry.REDSTONE_GEORE);
            this.addCrystalSounds(GeOreRegistry.RUBY_GEORE);
            this.addCrystalSounds(GeOreRegistry.SAPPHIRE_GEORE);
            this.addCrystalSounds(GeOreRegistry.TOPAZ_GEORE);
            this.addCrystalSounds(GeOreRegistry.ZINC_GEORE);
            this.addGeore(GeOreRegistry.COAL_GEORE);
            this.addGeore(GeOreRegistry.COPPER_GEORE);
            this.addGeore(GeOreRegistry.DIAMOND_GEORE);
            this.addGeore(GeOreRegistry.EMERALD_GEORE);
            this.addGeore(GeOreRegistry.GOLD_GEORE);
            this.addGeore(GeOreRegistry.IRON_GEORE);
            this.addGeore(GeOreRegistry.LAPIS_GEORE);
            this.addGeore(GeOreRegistry.QUARTZ_GEORE);
            this.addGeore(GeOreRegistry.REDSTONE_GEORE);
            this.addGeore(GeOreRegistry.RUBY_GEORE);
            this.addGeore(GeOreRegistry.SAPPHIRE_GEORE);
            this.addGeore(GeOreRegistry.TOPAZ_GEORE);
            this.addGeore(GeOreRegistry.ZINC_GEORE);
        }

        private void addMineable(GeOreBlockReg blockReg) {
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)blockReg.getCluster().get())).add((Object)((Block)blockReg.getSmallBud().get())).add((Object)((Block)blockReg.getMediumBud().get())).add((Object)((Block)blockReg.getLargeBud().get())).add((Object)((Block)blockReg.getBlock().get())).add((Object)((Block)blockReg.getBudding().get()));
        }

        private void addCrystalSounds(GeOreBlockReg blockReg) {
            this.tag(BlockTags.CRYSTAL_SOUND_BLOCKS).add((Object)((Block)blockReg.getBlock().get())).add((Object)((Block)blockReg.getBudding().get()));
        }

        private void addGeore(GeOreBlockReg blockReg) {
            TagKey<Block> budsTag = GeoreBlockTags.modTag("buds/geore_" + blockReg.getName());
            this.tag(budsTag).add((Object[])new Block[]{(Block)blockReg.getSmallBud().get(), (Block)blockReg.getMediumBud().get(), (Block)blockReg.getLargeBud().get()});
            this.tag(Tags.Blocks.BUDS).addTag(budsTag);
            TagKey<Block> clustersTag = GeoreBlockTags.modTag("clusters/geore_" + blockReg.getName());
            this.tag(clustersTag).add((Object)((Block)blockReg.getCluster().get()));
            this.tag(Tags.Blocks.CLUSTERS).addTag(clustersTag);
            this.tag(Tags.Blocks.BUDDING_BLOCKS).add((Object)((Block)blockReg.getBudding().get()));
            TagKey<Block> blockTag = GeoreBlockTags.modTag("storage_blocks/geore_" + blockReg.getName());
            this.tag(blockTag).add((Object)((Block)blockReg.getBlock().get()));
        }
    }

    public static class GeoreItemTags
    extends ItemTagsProvider {
        public static final TagKey<Item> GEORE_BUDDING = GeoreItemTags.modTag("geore_budding");
        public static final TagKey<Item> GEORE_CLUSTERS = GeoreItemTags.modTag("geore_clusters");
        public static final TagKey<Item> GEORE_SMALL_BUDS = GeoreItemTags.modTag("geore_small_buds");
        public static final TagKey<Item> GEORE_MEDIUM_BUDS = GeoreItemTags.modTag("geore_medium_buds");
        public static final TagKey<Item> GEORE_LARGE_BUDS = GeoreItemTags.modTag("geore_large_buds");
        public static final TagKey<Item> GEORE_SHARDS = GeoreItemTags.modTag("geore_shards");
        public static final TagKey<Item> GEORE_BLOCKS = GeoreItemTags.modTag("geore_blocks");

        public GeoreItemTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), "geore", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.addGeore(GeOreRegistry.COAL_GEORE);
            this.tag(ItemTags.COALS).add((Object)((Item)GeOreRegistry.COAL_GEORE.getShard().get()));
            this.addGeore(GeOreRegistry.COPPER_GEORE);
            this.addGeore(GeOreRegistry.DIAMOND_GEORE);
            this.addGeore(GeOreRegistry.EMERALD_GEORE);
            this.addGeore(GeOreRegistry.GOLD_GEORE);
            this.addGeore(GeOreRegistry.IRON_GEORE);
            this.addGeore(GeOreRegistry.LAPIS_GEORE);
            this.addGeore(GeOreRegistry.QUARTZ_GEORE);
            this.addGeore(GeOreRegistry.REDSTONE_GEORE);
            this.addGeore(GeOreRegistry.RUBY_GEORE);
            this.addGeore(GeOreRegistry.SAPPHIRE_GEORE);
            this.addGeore(GeOreRegistry.TOPAZ_GEORE);
            this.addGeore(GeOreRegistry.ZINC_GEORE);
            this.addStorage(GeOreRegistry.COAL_GEORE);
            this.addStorage(GeOreRegistry.COPPER_GEORE);
            this.addStorage(GeOreRegistry.DIAMOND_GEORE);
            this.addStorage(GeOreRegistry.EMERALD_GEORE);
            this.addStorage(GeOreRegistry.GOLD_GEORE);
            this.addStorage(GeOreRegistry.IRON_GEORE);
            this.addStorage(GeOreRegistry.LAPIS_GEORE);
            this.addStorage(GeOreRegistry.QUARTZ_GEORE);
            this.addStorage(GeOreRegistry.REDSTONE_GEORE);
            this.addStorage(GeOreRegistry.RUBY_GEORE);
            this.addStorage(GeOreRegistry.SAPPHIRE_GEORE);
            this.addStorage(GeOreRegistry.TOPAZ_GEORE);
            this.addStorage(GeOreRegistry.ZINC_GEORE);
            this.tag(Tags.Items.BUDDING_BLOCKS).addTag(GEORE_BUDDING);
            this.tag(Tags.Items.BUDS).addTags(new TagKey[]{GEORE_SMALL_BUDS, GEORE_MEDIUM_BUDS, GEORE_LARGE_BUDS});
            this.tag(Tags.Items.CLUSTERS).addTag(GEORE_CLUSTERS);
        }

        private void addStorage(GeOreBlockReg blockReg) {
            TagKey<Item> itemTag = GeoreItemTags.modTag("storage_blocks/geore_" + blockReg.getName());
            this.tag(itemTag).add((Object)((AmethystBlock)blockReg.getBlock().get()).asItem());
        }

        private void addGeore(GeOreBlockReg blockReg) {
            this.tag(GEORE_BUDDING).add((Object)((BuddingGeoreBlock)((Object)blockReg.getBudding().get())).asItem());
            TagKey<Item> smallBudsTag = GeoreItemTags.modTag("geore_small_buds/" + blockReg.getName());
            this.tag(GEORE_SMALL_BUDS).addTag(smallBudsTag);
            this.tag(smallBudsTag).add((Object)((AmethystClusterBlock)blockReg.getCluster().get()).asItem());
            TagKey<Item> mediumBudsTag = GeoreItemTags.modTag("geore_medium_buds/" + blockReg.getName());
            this.tag(GEORE_MEDIUM_BUDS).addTag(mediumBudsTag);
            this.tag(mediumBudsTag).add((Object)((AmethystClusterBlock)blockReg.getSmallBud().get()).asItem());
            TagKey<Item> largeBudsTag = GeoreItemTags.modTag("geore_large_buds/" + blockReg.getName());
            this.tag(GEORE_LARGE_BUDS).addTag(largeBudsTag);
            this.tag(largeBudsTag).add((Object)((AmethystClusterBlock)blockReg.getCluster().get()).asItem());
            TagKey<Item> clusterTag = GeoreItemTags.modTag("geore_clusters/" + blockReg.getName());
            this.tag(GEORE_CLUSTERS).addTag(clusterTag);
            this.tag(clusterTag).add((Object)((AmethystClusterBlock)blockReg.getCluster().get()).asItem());
            TagKey<Item> shardTag = GeoreItemTags.modTag("geore_shards/" + blockReg.getName());
            this.tag(GEORE_SHARDS).addTag(shardTag);
            this.tag(shardTag).add((Object)((Item)blockReg.getShard().get()));
            TagKey<Item> blockTag = GeoreItemTags.modTag("geore_blocks/" + blockReg.getName());
            this.tag(GEORE_BLOCKS).addTag(blockTag);
            this.tag(blockTag).add((Object)((AmethystBlock)blockReg.getBlock().get()).asItem());
        }

        private static TagKey<Item> modTag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"geore", (String)name));
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "geore", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.geore", "GeOre");
            this.generateLang("Coal", GeOreRegistry.COAL_GEORE);
            this.generateLang("Copper", GeOreRegistry.COPPER_GEORE);
            this.generateLang("Diamond", GeOreRegistry.DIAMOND_GEORE);
            this.generateLang("Emerald", GeOreRegistry.EMERALD_GEORE);
            this.generateLang("Gold", GeOreRegistry.GOLD_GEORE);
            this.generateLang("Iron", GeOreRegistry.IRON_GEORE);
            this.generateLang("Lapis", GeOreRegistry.LAPIS_GEORE);
            this.generateLang("Quartz", GeOreRegistry.QUARTZ_GEORE);
            this.generateLang("Redstone", GeOreRegistry.REDSTONE_GEORE);
            this.generateLang("Ruby", GeOreRegistry.RUBY_GEORE);
            this.generateLang("Sapphire", GeOreRegistry.SAPPHIRE_GEORE);
            this.generateLang("Topaz", GeOreRegistry.TOPAZ_GEORE);
            this.generateLang("Zinc", GeOreRegistry.ZINC_GEORE);
            this.add("geore.configuration.title", "Grimoire of Gaia Settings");
            this.addConfig("Client", "Client", "Client Settings");
            this.addConfig("spyglassIntensity", "Spyglass Intensity", "The intensity of the spyglass color overlay (0.5 = 50%) [Default: 0.5]");
            this.addConfig("General", "General", "General settings");
            this.addConfig("generateCoalGeore", "Generate Coal GeOre", "Generate Coal GeOre [Default: true]");
            this.addConfig("generateCopperGeore", "Generate Copper GeOre", "Generate Copper GeOre [Default: true]");
            this.addConfig("generateDiamondGeore", "Generate Diamond GeOre", "Generate Diamond GeOre [Default: true]");
            this.addConfig("generateEmeraldGeore", "Generate Emerald GeOre", "Generate Emerald GeOre [Default: true]");
            this.addConfig("generateGoldGeore", "Generate Gold GeOre", "Generate Gold GeOre [Default: true]");
            this.addConfig("generateIronGeore", "Generate Iron GeOre", "Generate Iron GeOre [Default: true]");
            this.addConfig("generateLapisGeore", "Generate Lapis GeOre", "Generate Lapis GeOre [Default: true]");
            this.addConfig("generateQuartzGeore", "Generate Quartz GeOre", "Generate Quartz GeOre [Default: true]");
            this.addConfig("generateQuartzInNetherGeore", "Generate Quartz In Nether GeOre", "Generate Quartz In Nether GeOre [Default: true]");
            this.addConfig("generateRedstoneGeore", "Generate Redstone GeOre", "Generate Redstone GeOre [Default: true]");
            this.addConfig("disablePistonPushForBuddingGeOre", "Disable Piston Push For Budding GeOre", "Disable piston push for budding GeOre (Overrides the vanilla behavior of breaking the block upon being pushed) [Default: false]");
            this.addConfig("ModdedGeneration", "Modded Generation", "Modded Generation Settings");
            this.addConfig("generateRubyGeore", "Generate Ruby GeOre", "Generate Ruby GeOre [Default: false]");
            this.addConfig("generateSapphireGeore", "Generate Sapphire GeOre", "Generate Sapphire GeOre [Default: false]");
            this.addConfig("generateTopazGeore", "Generate Topaz GeOre", "Generate Topaz GeOre [Default: false]");
            this.addConfig("generateZincGeore", "Generate Zinc GeOre", "Generate Zinc GeOre [Default: false]");
        }

        public void generateLang(String name, GeOreBlockReg blockReg) {
            this.addBlock((Supplier)blockReg.getBlock(), "Block Of " + name + " Geore");
            this.addBlock((Supplier)blockReg.getBudding(), "Budding " + name + " Geore");
            this.addBlock((Supplier)blockReg.getSmallBud(), "Small " + name + " Geore Bud");
            this.addBlock((Supplier)blockReg.getMediumBud(), "Medium " + name + " Geore Bud");
            this.addBlock((Supplier)blockReg.getLargeBud(), "Large " + name + " Geore Bud");
            this.addBlock((Supplier)blockReg.getCluster(), name + " Geore Cluster");
            this.addItem((Supplier)blockReg.getShard(), name + " Geore Shard");
            this.addItem((Supplier)blockReg.getSpyglass(), name + " Geore Spyglass");
        }

        private void addConfig(String path, String name, String description) {
            this.add("geore.configuration." + path, name);
            this.add("geore.configuration." + path + ".tooltip", description);
        }
    }

    private static class BlockModels
    extends BlockModelProvider {
        public BlockModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "geore", helper);
        }

        protected void registerModels() {
            this.generateGeoreModels(GeOreRegistry.COAL_GEORE);
            this.generateGeoreModels(GeOreRegistry.COPPER_GEORE);
            this.generateGeoreModels(GeOreRegistry.DIAMOND_GEORE);
            this.generateGeoreModels(GeOreRegistry.EMERALD_GEORE);
            this.generateGeoreModels(GeOreRegistry.GOLD_GEORE);
            this.generateGeoreModels(GeOreRegistry.IRON_GEORE);
            this.generateGeoreModels(GeOreRegistry.LAPIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.REDSTONE_GEORE);
            this.generateGeoreModels(GeOreRegistry.RUBY_GEORE);
            this.generateGeoreModels(GeOreRegistry.SAPPHIRE_GEORE);
            this.generateGeoreModels(GeOreRegistry.TOPAZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.ZINC_GEORE);
        }

        protected void generateGeoreModels(GeOreBlockReg blockReg) {
            this.cubeAll(blockReg.getBlock().getId().getPath(), this.modLoc("block/" + blockReg.getBlock().getId().getPath()));
            this.cubeAll(blockReg.getBudding().getId().getPath(), this.modLoc("block/" + blockReg.getBudding().getId().getPath()));
            this.crossBlock((Block)blockReg.getCluster().get());
            this.crossBlock((Block)blockReg.getSmallBud().get());
            this.crossBlock((Block)blockReg.getMediumBud().get());
            this.crossBlock((Block)blockReg.getLargeBud().get());
        }

        private void crossBlock(Block block) {
            String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
            ((BlockModelBuilder)this.cross(path, this.modLoc("block/" + path))).renderType("cutout");
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "geore", helper);
        }

        protected void registerModels() {
            this.generateGeoreModels(GeOreRegistry.COAL_GEORE);
            this.generateGeoreModels(GeOreRegistry.COPPER_GEORE);
            this.generateGeoreModels(GeOreRegistry.DIAMOND_GEORE);
            this.generateGeoreModels(GeOreRegistry.EMERALD_GEORE);
            this.generateGeoreModels(GeOreRegistry.GOLD_GEORE);
            this.generateGeoreModels(GeOreRegistry.IRON_GEORE);
            this.generateGeoreModels(GeOreRegistry.LAPIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.REDSTONE_GEORE);
            this.generateGeoreModels(GeOreRegistry.RUBY_GEORE);
            this.generateGeoreModels(GeOreRegistry.SAPPHIRE_GEORE);
            this.generateGeoreModels(GeOreRegistry.TOPAZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.ZINC_GEORE);
        }

        protected void generateGeoreModels(GeOreBlockReg blockReg) {
            this.singleTexture(blockReg.getShard().getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"geore", (String)("item/" + blockReg.getShard().getId().getPath())));
            this.withExistingParent(blockReg.getBlock().getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"geore", (String)("block/" + blockReg.getBlock().getId().getPath())));
            this.withExistingParent(blockReg.getBudding().getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"geore", (String)("block/" + blockReg.getBudding().getId().getPath())));
            this.makeCluster(blockReg.getCluster());
            this.makeSmallBud(blockReg.getSmallBud());
            this.makeMediumBud(blockReg.getMediumBud());
            this.makeLargeBud(blockReg.getLargeBud());
            this.makeSpyglass(blockReg.getSpyglass());
        }

        private void makeSpyglass(DeferredHolder<Item, GeoreSpyglassItem> spyglass) {
            String path = spyglass.getId().getPath();
            ModelBuilder spyglass_gui = ((ItemModelBuilder)this.withExistingParent(path + "_gui", this.mcLoc("spyglass"))).texture("layer0", this.modLoc("item/" + path));
            ModelBuilder spyglass_hand = ((ItemModelBuilder)this.withExistingParent(path + "_in_hand", this.mcLoc("spyglass_in_hand"))).texture("spyglass", this.modLoc("item/" + path + "_model"));
            ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(path, "neoforge:item/default")).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_hand))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).end();
        }

        private void makeCluster(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
            String path = deferredHolder.getId().getPath();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.HEAD).translation(0.0f, 14.0f, -5.0f).end();
        }

        private void makeSmallBud(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
            String path = deferredHolder.getId().getPath();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(0.0f, 6.0f, 0.0f).scale(0.68f, 0.68f, 0.68f).end().transform(ItemDisplayContext.FIXED).translation(0.0f, 7.0f, 0.0f).end();
        }

        private void makeMediumBud(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
            String path = deferredHolder.getId().getPath();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.FIXED).translation(0.0f, 6.0f, 0.0f).end();
        }

        private void makeLargeBud(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
            String path = deferredHolder.getId().getPath();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.FIXED).translation(0.0f, 4.0f, 0.0f).end();
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "geore", helper);
        }

        protected void registerStatesAndModels() {
            this.generateGeoreModels(GeOreRegistry.COAL_GEORE);
            this.generateGeoreModels(GeOreRegistry.COPPER_GEORE);
            this.generateGeoreModels(GeOreRegistry.DIAMOND_GEORE);
            this.generateGeoreModels(GeOreRegistry.EMERALD_GEORE);
            this.generateGeoreModels(GeOreRegistry.GOLD_GEORE);
            this.generateGeoreModels(GeOreRegistry.IRON_GEORE);
            this.generateGeoreModels(GeOreRegistry.LAPIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.REDSTONE_GEORE);
            this.generateGeoreModels(GeOreRegistry.RUBY_GEORE);
            this.generateGeoreModels(GeOreRegistry.SAPPHIRE_GEORE);
            this.generateGeoreModels(GeOreRegistry.TOPAZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.ZINC_GEORE);
        }

        protected void generateGeoreModels(GeOreBlockReg blockReg) {
            this.simpleBlock((Block)blockReg.getBlock().get());
            this.simpleBlock((Block)blockReg.getBudding().get());
            this.clusterBlock((Block)blockReg.getCluster().get());
            this.clusterBlock((Block)blockReg.getLargeBud().get());
            this.clusterBlock((Block)blockReg.getMediumBud().get());
            this.clusterBlock((Block)blockReg.getSmallBud().get());
        }

        private void clusterBlock(Block block) {
            ModelFile.ExistingModelFile clusterBlock = this.models().getExistingFile(this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath()));
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)clusterBlock).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)clusterBlock).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).rotationY(270).addModel();
        }
    }
}

