/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.config;

import com.shynieke.geore.GeOre;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GeOreConfig {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        GeOre.LOGGER.debug("Loaded GeOre's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        GeOre.LOGGER.debug("GeOre's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.DoubleValue spyglassIntensity;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client settings").push("Client");
            this.spyglassIntensity = builder.comment("The intensity of the spyglass color overlay (0.5 = 50%) [Default: 0.5]").defineInRange("spyglassIntensity", 0.5, 0.01, 1.0);
            builder.pop();
        }
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue generateCoalGeore;
        public final ModConfigSpec.BooleanValue generateCopperGeore;
        public final ModConfigSpec.BooleanValue generateDiamondGeore;
        public final ModConfigSpec.BooleanValue generateEmeraldGeore;
        public final ModConfigSpec.BooleanValue generateGoldGeore;
        public final ModConfigSpec.BooleanValue generateIronGeore;
        public final ModConfigSpec.BooleanValue generateLapisGeore;
        public final ModConfigSpec.BooleanValue generateQuartzGeore;
        public final ModConfigSpec.BooleanValue generateQuartzInNetherGeore;
        public final ModConfigSpec.BooleanValue generateRedstoneGeore;
        public final ModConfigSpec.BooleanValue disablePistonPushForBuddingGeOre;
        public final ModConfigSpec.BooleanValue generateRubyGeore;
        public final ModConfigSpec.BooleanValue generateSapphireGeore;
        public final ModConfigSpec.BooleanValue generateTopazGeore;
        public final ModConfigSpec.BooleanValue generateZincGeore;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.generateCoalGeore = builder.comment("Generate Coal GeOre [Default: true]").define("generateCoalGeore", true);
            this.generateCopperGeore = builder.comment("Generate Copper GeOre [Default: true]").define("generateCopperGeore", true);
            this.generateDiamondGeore = builder.comment("Generate Diamond GeOre [Default: true]").define("generateDiamondGeore", true);
            this.generateEmeraldGeore = builder.comment("Generate Emerald GeOre [Default: true]").define("generateEmeraldGeore", true);
            this.generateGoldGeore = builder.comment("Generate Gold GeOre [Default: true]").define("generateGoldGeore", true);
            this.generateIronGeore = builder.comment("Generate Iron GeOre [Default: true]").define("generateIronGeore", true);
            this.generateLapisGeore = builder.comment("Generate Lapis GeOre [Default: true]").define("generateLapisGeore", true);
            this.generateQuartzGeore = builder.comment("Generate Quartz GeOre [Default: true]").define("generateQuartzGeore", true);
            this.generateQuartzInNetherGeore = builder.comment("Generate Quartz GeOre in the Nether [Default: true]").define("generateQuartzInNetherGeore", true);
            this.generateRedstoneGeore = builder.comment("Generate Redstone GeOre [Default: true]").define("generateRedstoneGeore", true);
            this.disablePistonPushForBuddingGeOre = builder.comment("Disable piston push for budding GeOre (Overrides the vanilla behavior of breaking the block upon being pushed) [Default: false]").define("disablePistonPushForBuddingGeOre", false);
            builder.pop();
            builder.comment("Modded Generation settings").push("ModdedGeneration");
            this.generateRubyGeore = builder.comment("Generate Ruby GeOre [Default: false]").define("generateRubyGeore", false);
            this.generateSapphireGeore = builder.comment("Generate Sapphire GeOre [Default: false]").define("generateSapphireGeore", false);
            this.generateTopazGeore = builder.comment("Generate Topaz GeOre [Default: false]").define("generateTopazGeore", false);
            this.generateZincGeore = builder.comment("Generate Zinc GeOre [Default: false]").define("generateZincGeore", false);
            builder.pop();
        }
    }
}

