/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.shynieke.geore.config.GeOreConfig;
import com.shynieke.geore.item.GeoreSpyglassItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import org.joml.Matrix4f;

public class SpyglassHandler {
    @SubscribeEvent
    public void onOverlayRender(RenderGuiLayerEvent.Pre event) {
        Item item;
        if (!event.getName().equals((Object)ResourceLocation.parse((String)"camera_overlays"))) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = Minecraft.getInstance().player;
        PoseStack poseStack = event.getGuiGraphics().pose();
        if (player != null && minecraft.options.getCameraType().isFirstPerson() && player.isUsingItem() && (item = player.getUseItem().getItem()) instanceof GeoreSpyglassItem) {
            GeoreSpyglassItem georeSpyglassItem = (GeoreSpyglassItem)item;
            int color = georeSpyglassItem.getOverlayHex();
            RenderSystem.enableBlend();
            this.fillGradient(poseStack, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight(), color, color);
            RenderSystem.defaultBlendFunc();
        }
    }

    protected void fillGradient(PoseStack poseStack, int width, int height, int color1, int color2) {
        SpyglassHandler.fillGradient(poseStack, width, height, color1, color2, ((Double)GeOreConfig.CLIENT.spyglassIntensity.get()).floatValue());
    }

    protected static void fillGradient(PoseStack poseStack, int width, int height, int color1, int color2, float intensity) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        SpyglassHandler.fillGradient(poseStack.last().pose(), bufferbuilder, width, height, color1, color2, intensity);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected static void fillGradient(Matrix4f matrix4f, BufferBuilder builder, int width, int height, int color1, int color2, float intensity) {
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        builder.addVertex(matrix4f, (float)width, 0.0f, 0.0f).setColor(f1, f2, f3, intensity);
        builder.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(f1, f2, f3, intensity);
        builder.addVertex(matrix4f, 0.0f, (float)height, 0.0f).setColor(f5, f6, f7, intensity);
        builder.addVertex(matrix4f, (float)width, (float)height, 0.0f).setColor(f5, f6, f7, intensity);
    }
}

