/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IShearable;

public class BaseShearsItem
extends ShearsItem {
    public BaseShearsItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.apply(new Item.Properties()));
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (level.isClientSide()) {
            return false;
        }
        Block block = state.getBlock();
        if (block instanceof IShearable) {
            BlockEntity tile = level.getBlockEntity(pos);
            LootParams.Builder params = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)Items.SHEARS)).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)tile);
            List drops = state.getDrops(params);
            Random rand = new Random();
            for (ItemStack drop : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (1.0 - (double)f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (1.0 - (double)f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (1.0 - (double)f) * 0.5;
                ItemEntity item = new ItemEntity(level, (double)pos.getX() + d, (double)pos.getY() + d1, (double)pos.getZ() + d2, drop);
                item.setPickUpDelay(10);
                level.addFreshEntity((Entity)item);
            }
            stack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.awardStat(Stats.BLOCK_MINED.get((Object)block), 1);
            }
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            return true;
        }
        return false;
    }
}

