/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.inventory;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CanExtractFunction;
import com.blakebr0.cucumber.inventory.CanInsertFunction;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class SidedInventoryWrapper
implements IItemHandler {
    private final BaseItemStackHandler inventory;
    private final Direction direction;
    private final CanInsertFunction.Sided canInsert;
    private final CanExtractFunction.Sided canExtract;

    private SidedInventoryWrapper(BaseItemStackHandler inventory, Direction direction, @Nullable CanInsertFunction.Sided canInsert, @Nullable CanExtractFunction.Sided canExtract) {
        this.inventory = inventory;
        this.direction = direction;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.inventory.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canExtract != null && !this.canExtract.apply(slot, this.direction)) {
            return ItemStack.EMPTY;
        }
        return this.inventory.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.canInsert != null && this.canInsert.apply(slot, stack, this.direction) && this.inventory.isItemValid(slot, stack);
    }

    public static SidedInventoryWrapper[] create(BaseItemStackHandler inventory, List<Direction> directions, CanInsertFunction.Sided canInsert, CanExtractFunction.Sided canExtract) {
        SidedInventoryWrapper[] wrappers = new SidedInventoryWrapper[directions.size()];
        for (int i = 0; i < directions.size(); ++i) {
            wrappers[i] = new SidedInventoryWrapper(inventory, directions.get(i), canInsert, canExtract);
        }
        return wrappers;
    }
}

