/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.ingredient;

import com.blakebr0.cucumber.init.ModIngredientTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public class IngredientWithCount
implements ICustomIngredient,
Predicate<ItemStack> {
    public static final IngredientWithCount EMPTY = new IngredientWithCount((Ingredient.Value)new Ingredient.ItemValue(ItemStack.EMPTY), 0);
    public static final MapCodec<IngredientWithCount> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.Value.MAP_CODEC.forGetter(ingredient -> ingredient.value), (App)Codec.INT.fieldOf("count").forGetter(ingredient -> ingredient.count)).apply((Applicative)builder, IngredientWithCount::new));
    public static final Codec<IngredientWithCount> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientWithCount> STREAM_CODEC = StreamCodec.of((buffer, ingredient) -> {
        ItemStack stack = ingredient.getItems().findFirst().orElseThrow();
        ItemStack.STREAM_CODEC.encode(buffer, (Object)stack);
        buffer.writeInt(ingredient.count);
    }, buffer -> {
        ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode(buffer);
        int count = buffer.readInt();
        return new IngredientWithCount((Ingredient.Value)new Ingredient.ItemValue(stack), count);
    });
    private final Ingredient.Value value;
    private final int count;
    private ItemStack[] stacks;

    public IngredientWithCount(Ingredient.Value value, int count) {
        this.value = value;
        this.count = count;
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.stacks == null) {
            this.stacks = this.value.getItems().toArray(new ItemStack[0]);
        }
        return stack.getCount() >= this.count && Arrays.stream(this.stacks).anyMatch(s -> s.is(stack.getItem()));
    }

    public Stream<ItemStack> getItems() {
        if (this.stacks == null) {
            this.stacks = this.value.getItems().toArray(new ItemStack[0]);
        }
        return Stream.of(this.stacks);
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypes.WITH_COUNT.get();
    }

    public int getCount() {
        return this.count;
    }

    public static Ingredient of(ItemStack item, int count) {
        return new IngredientWithCount((Ingredient.Value)new Ingredient.ItemValue(item), count).toVanilla();
    }
}

