/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.compat.almostunified.AlmostUnifiedAdapter;
import com.blakebr0.cucumber.config.ModConfigs;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import org.apache.commons.io.IOUtils;

public class TagMapper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<String, String> TAG_TO_ITEM_MAP = new HashMap<String, String>();

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.shouldUpdateStaticData()) {
            TagMapper.reloadTagMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadTagMappings() {
        Stopwatch stopwatch;
        block5: {
            File file;
            block6: {
                stopwatch = Stopwatch.createStarted();
                File dir = FMLPaths.CONFIGDIR.get().toFile();
                TAG_TO_ITEM_MAP.clear();
                if (!dir.exists() || !dir.isDirectory()) break block5;
                file = FMLPaths.CONFIGDIR.get().resolve("cucumber-tags.json").toFile();
                if (!file.exists() || !file.isFile()) break block6;
                FileReader reader = null;
                try {
                    reader = new FileReader(file);
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    json.entrySet().stream().filter(e -> {
                        String value = ((JsonElement)e.getValue()).getAsString();
                        return !"__comment".equalsIgnoreCase((String)e.getKey()) && !value.isEmpty() && !"null".equalsIgnoreCase(value);
                    }).forEach(entry -> {
                        Item item;
                        String tagId = (String)entry.getKey();
                        String itemId = ((JsonElement)entry.getValue()).getAsString();
                        TAG_TO_ITEM_MAP.put(tagId, itemId);
                        if (!(!((Boolean)ModConfigs.AUTO_REFRESH_TAG_ENTRIES.get()).booleanValue() || itemId.isEmpty() || "null".equalsIgnoreCase(itemId) || (item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemId))) != null && item != Items.AIR)) {
                            TagMapper.addTagToFile(tagId, json, file, false);
                        }
                    });
                    if (((Boolean)ModConfigs.AUTO_REFRESH_TAG_ENTRIES.get()).booleanValue()) {
                        TagMapper.saveToFile(json, file);
                    }
                    reader.close();
                }
                catch (Exception e2) {
                    try {
                        Cucumber.LOGGER.error("An error occurred while reading cucumber-tags.json", (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block5;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block5;
            }
            TagMapper.generateNewConfig(file);
        }
        stopwatch.stop();
        Cucumber.LOGGER.info("Loaded cucumber-tags.json in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item getItemForTag(String tagId) {
        block10: {
            Item preferredItem = AlmostUnifiedAdapter.getPreferredItemForTag(tagId);
            if (preferredItem != null) {
                return preferredItem;
            }
            if (TAG_TO_ITEM_MAP.containsKey(tagId)) {
                String id = TAG_TO_ITEM_MAP.get(tagId);
                return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id));
            }
            File file = FMLPaths.CONFIGDIR.get().resolve("cucumber-tags.json").toFile();
            if (!file.exists()) {
                TagMapper.generateNewConfig(file);
            }
            if (!file.isFile()) break block10;
            JsonObject json = null;
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                try {
                    Cucumber.LOGGER.error("An error occurred while reading cucumber-tags.json", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (json != null) {
                if (json.has(tagId)) {
                    String itemId = json.get(tagId).getAsString();
                    if (itemId.isEmpty() || "null".equalsIgnoreCase(itemId)) {
                        return TagMapper.addTagToFile(tagId, json, file);
                    }
                    TAG_TO_ITEM_MAP.put(tagId, itemId);
                    return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemId));
                }
                return TagMapper.addTagToFile(tagId, json, file);
            }
        }
        return Items.AIR;
    }

    public static ItemStack getItemStackForTag(String tagId, int size) {
        Item item = TagMapper.getItemForTag(tagId);
        return item != null && item != Items.AIR ? new ItemStack((ItemLike)item, size) : ItemStack.EMPTY;
    }

    private static Item addTagToFile(String tagId, JsonObject json, File file) {
        return TagMapper.addTagToFile(tagId, json, file, true);
    }

    private static Item addTagToFile(String tagId, JsonObject json, File file, boolean save) {
        List mods = (List)ModConfigs.MOD_TAG_PRIORITIES.get();
        TagKey key = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)tagId));
        Item item = BuiltInRegistries.ITEM.getTag(key).stream().min((item1, item2) -> {
            ResourceLocation id2;
            int index2;
            ResourceLocation id1 = BuiltInRegistries.ITEM.getKey((Object)((Item)item1.get(0).value()));
            int index1 = mods.indexOf(id1.getNamespace());
            return index1 > (index2 = mods.indexOf((id2 = BuiltInRegistries.ITEM.getKey((Object)((Item)item2.get(0).value()))).getNamespace())) ? 1 : (index1 == -1 ? 0 : -1);
        }).map(v -> (Item)v.get(0).value()).orElse(Items.AIR);
        String itemId = "null";
        if (item != Items.AIR && BuiltInRegistries.ITEM.containsValue((Object)item)) {
            itemId = BuiltInRegistries.ITEM.getKey((Object)item).toString();
        }
        json.addProperty(tagId, itemId);
        TAG_TO_ITEM_MAP.put(tagId, itemId);
        if (save) {
            TagMapper.saveToFile(json, file);
        }
        return item;
    }

    private static void saveToFile(JsonObject json, File file) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            Cucumber.LOGGER.error("An error occurred while writing to cucumber-tags.json", (Throwable)e);
        }
    }

    private static void generateNewConfig(File file) {
        try (FileWriter writer = new FileWriter(file);){
            JsonObject object = new JsonObject();
            object.addProperty("__comment", "Instructions: https://blakesmods.com/docs/cucumber/tags-config");
            GSON.toJson((JsonElement)object, (Appendable)writer);
        }
        catch (IOException e) {
            Cucumber.LOGGER.error("An error occurred while creating cucumber-tags.json", (Throwable)e);
        }
    }
}

