/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.renderer;

import com.anthonyhilyard.iceberg.renderer.CheckedBufferSource;
import com.anthonyhilyard.iceberg.renderer.VertexCollector;
import com.anthonyhilyard.iceberg.util.EntityCollector;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.ItemUtil;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.mojang.math.MatrixUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CustomItemRenderer
extends ItemRenderer {
    private static RenderTarget iconFrameBuffer = null;
    private static ArmorStand armorStand = null;
    private static Wolf wolf = null;
    private static Horse horse = null;
    private static Entity entity = null;
    private static Pair<Item, DataComponentMap> cachedArmorStandItem = null;
    private static Pair<Item, DataComponentMap> cachedHorseArmorItem = null;
    private static Pair<Item, DataComponentMap> cachedWolfArmorItem = null;
    private static Pair<Item, DataComponentMap> cachedEntityItem = null;
    private static Map<Pair<Item, DataComponentMap>, ModelBounds> modelBoundsCache = Maps.newHashMap();
    private static final List<Direction> quadDirections = new ArrayList<Direction>(Arrays.asList(Direction.values()));
    private Minecraft minecraft;
    private final ModelManager modelManager;
    private final BlockEntityWithoutLevelRenderer blockEntityRenderer;

    public CustomItemRenderer(TextureManager textureManagerIn, ModelManager modelManagerIn, ItemColors itemColorsIn, BlockEntityWithoutLevelRenderer blockEntityRendererIn, Minecraft mcIn) {
        super(mcIn, textureManagerIn, modelManagerIn, itemColorsIn, blockEntityRendererIn);
        this.minecraft = mcIn;
        this.modelManager = modelManagerIn;
        this.blockEntityRenderer = blockEntityRendererIn;
        ResourceManager resourceManager = this.minecraft.getResourceManager();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
            resourceManager2.registerReloadListener((PreparableReloadListener)this);
        }
        if (iconFrameBuffer == null) {
            iconFrameBuffer = new MainTarget(96, 96);
            iconFrameBuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            iconFrameBuffer.clear(Minecraft.ON_OSX);
        }
    }

    private void renderGuiModel(ItemStack itemStack, int x, int y, Quaternionf rotation, BakedModel bakedModel, GuiGraphics graphics) {
        boolean flatLighting;
        this.minecraft.getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.translate((float)x + 8.0f, (float)y + 8.0f, 150.0f);
        modelViewStack.mul((Matrix4fc)new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        modelViewStack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flatLighting = !bakedModel.usesBlockLight();
        if (flatLighting) {
            Lighting.setupForFlatItems();
        }
        PoseStack poseStack = new PoseStack();
        this.renderModel(itemStack, ItemDisplayContext.GUI, false, poseStack, rotation, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        RenderSystem.disableDepthTest();
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        if (flatLighting) {
            Lighting.setupFor3DItems();
        }
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private void renderEntityModel(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Minecraft minecraft = Minecraft.getInstance();
        EntityRenderDispatcher entityRenderDispatcher = minecraft.getEntityRenderDispatcher();
        Lighting.setupForEntityInInventory();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityRenderDispatcher.setRenderShadow(false);
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        try {
            RenderSystem.runAsFancy(() -> entityRenderDispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, bufferSource, packedLight));
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.popPose();
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferSource;
            source.endBatch();
        }
        entityRenderDispatcher.setRenderShadow(true);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
    }

    private <T extends MultiBufferSource> void renderModelInternal(ItemStack itemStack, ItemDisplayContext displayContext, boolean leftHanded, PoseStack poseStack, Quaternionf rotation, T bufferSource, int packedLight, int packedOverlay, BakedModel bakedModel, Predicate<T> bufferSourceReady) {
        Minecraft minecraft = Minecraft.getInstance();
        if (ItemUtil.getEquipmentSlot(itemStack).isArmor() && this.updateArmorStand(itemStack)) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            this.renderEntityModel((Entity)armorStand, poseStack, bufferSource, packedLight);
            poseStack.popPose();
        }
        if (!bakedModel.isCustomRenderer() && !itemStack.is(Items.TRIDENT)) {
            BlockItem blockItem;
            Item block;
            Item item;
            boolean fabulous = displayContext != ItemDisplayContext.GUI && !displayContext.firstPerson() && (item = itemStack.getItem()) instanceof BlockItem ? !((block = (blockItem = (BlockItem)item).getBlock()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
            if (bufferSourceReady.test(bufferSource) && (block = itemStack.getItem()) instanceof BlockItem) {
                Block block2;
                blockItem = (BlockItem)block;
                block = blockItem.getBlock();
                BakedModel blockModel = null;
                BlockModelShaper blockModelShaper = minecraft.getBlockRenderer().getBlockModelShaper();
                boolean isBlockEntity = false;
                blockModel = blockModelShaper.getBlockModel(block.defaultBlockState());
                if (blockModel != this.modelManager.getMissingModel()) {
                    try {
                        this.blockEntityRenderer.renderByItem(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay);
                    }
                    catch (Exception exception) {}
                } else {
                    blockModel = null;
                }
                if (block.defaultBlockState().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                    BlockState bottomState = (BlockState)block.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER);
                    BakedModel bottomModel = blockModelShaper.getBlockModel(bottomState);
                    this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, bottomModel, fabulous);
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 1.0f, 0.0f);
                    BlockState topState = (BlockState)block.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER);
                    BakedModel topModel = blockModelShaper.getBlockModel(topState);
                    this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, topModel, fabulous);
                    poseStack.popPose();
                }
                if ((block2 = blockItem.getBlock()) instanceof EntityBlock) {
                    EntityBlock entityBlock = (EntityBlock)block2;
                    isBlockEntity = true;
                    try {
                        this.renderBlockEntity(itemStack, poseStack, bufferSource, packedLight, packedOverlay, minecraft, entityBlock, blockItem.getBlock().defaultBlockState());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (blockModel != null && (bufferSourceReady.test(bufferSource) || isBlockEntity)) {
                    this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, blockModel, fabulous);
                }
            }
            if (bufferSourceReady.test(bufferSource) && EntityCollector.itemCreatesEntity(itemStack, Entity.class) && this.updateEntity(itemStack)) {
                this.renderEntityModel(entity, poseStack, bufferSource, packedLight);
            }
            if (bufferSourceReady.test(bufferSource) && (item = itemStack.getItem()) instanceof AnimalArmorItem) {
                AnimalArmorItem animalArmor = (AnimalArmorItem)item;
                switch (animalArmor.getBodyType()) {
                    case EQUESTRIAN: {
                        if (!this.updateHorseArmor(itemStack)) break;
                        this.renderEntityModel((Entity)horse, poseStack, bufferSource, packedLight);
                        break;
                    }
                    case CANINE: {
                        if (!this.updateWolfArmor(itemStack)) break;
                        this.renderEntityModel((Entity)wolf, poseStack, bufferSource, packedLight);
                    }
                }
            }
            if (bufferSourceReady.test(bufferSource)) {
                this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, bakedModel, fabulous);
            }
        } else if (bufferSourceReady.test(bufferSource)) {
            this.blockEntityRenderer.renderByItem(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private void renderModel(ItemStack itemStack, ItemDisplayContext displayContext, boolean leftHanded, PoseStack poseStack, Quaternionf rotation, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BakedModel bakedModel) {
        if (!itemStack.isEmpty()) {
            ItemDisplayContext previewContext = displayContext;
            if (!bakedModel.getTransforms().hasTransform(displayContext)) {
                previewContext = ItemDisplayContext.GROUND;
            }
            boolean isBlockItem = false;
            boolean spawnsEntity = false;
            boolean isArmor = false;
            if (itemStack.getItem() instanceof BlockItem) {
                isBlockItem = true;
            } else if (EntityCollector.itemCreatesEntity(itemStack, Entity.class)) {
                spawnsEntity = true;
            }
            if (ItemUtil.getEquipmentSlot(itemStack).isArmor()) {
                isArmor = true;
            }
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            if (isBlockItem || spawnsEntity) {
                poseStack.mulPose(new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
            } else {
                bakedModel.getTransforms().getTransform(previewContext).apply(leftHanded, poseStack);
            }
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            ModelBounds modelBounds = this.getModelBounds(itemStack, previewContext, leftHanded, poseStack, rotation, bufferSource, packedLight, packedOverlay, bakedModel);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.mulPose(rotation);
            float scale = 0.8f / Math.max(modelBounds.height, modelBounds.radius * 2.0f);
            if (isArmor) {
                switch (ItemUtil.getEquipmentSlot(itemStack)) {
                    case HEAD: {
                        scale *= 0.75f;
                        break;
                    }
                    case LEGS: {
                        scale *= 1.3f;
                        break;
                    }
                    case FEET: {
                        scale *= 0.85f;
                        break;
                    }
                }
            }
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-modelBounds.center.x(), -modelBounds.center.y(), -modelBounds.center.z());
            poseStack.translate(0.5f, 0.5f, 0.5f);
            if (isBlockItem || spawnsEntity) {
                poseStack.mulPose(new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
            } else {
                bakedModel.getTransforms().getTransform(previewContext).apply(leftHanded, poseStack);
            }
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            CheckedBufferSource checkedBufferSource = CheckedBufferSource.create(bufferSource);
            this.renderModelInternal(itemStack, previewContext, leftHanded, poseStack, rotation, checkedBufferSource, packedLight, packedOverlay, bakedModel, b -> !b.hasRendered());
            poseStack.popPose();
        }
    }

    private void renderBlockEntity(ItemStack itemStack, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Minecraft minecraft, EntityBlock entityBlock, BlockState blockState) throws Exception {
        BlockEntity blockEntity = entityBlock.newBlockEntity(BlockPos.ZERO, blockState);
        if (blockEntity != null) {
            blockEntity.applyComponentsFromItemStack(itemStack);
            BlockEntityRenderer renderer = minecraft.getBlockEntityRenderDispatcher().getRenderer(blockEntity);
            if (renderer != null) {
                renderer.render(blockEntity, minecraft.getTimer().getRealtimeDeltaTicks(), poseStack, bufferSource, packedLight, packedOverlay);
            }
        }
    }

    private void renderBakedModel(ItemStack itemStack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BakedModel bakedModel, boolean fabulous) {
        VertexConsumer vertexConsumer;
        RenderType renderType = ItemBlockRenderTypes.getRenderType((ItemStack)itemStack, (boolean)fabulous);
        if (CustomItemRenderer.hasAnimatedTexture((ItemStack)itemStack) && itemStack.hasFoil()) {
            PoseStack.Pose pose = poseStack.last().copy();
            if (displayContext == ItemDisplayContext.GUI) {
                MatrixUtil.mulComponentWise((Matrix4f)pose.pose(), (float)0.5f);
            } else if (displayContext.firstPerson()) {
                MatrixUtil.mulComponentWise((Matrix4f)pose.pose(), (float)0.75f);
            }
            vertexConsumer = CustomItemRenderer.getCompassFoilBuffer((MultiBufferSource)bufferSource, (RenderType)renderType, (PoseStack.Pose)pose);
        } else {
            vertexConsumer = fabulous ? CustomItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (boolean)itemStack.hasFoil()) : CustomItemRenderer.getFoilBuffer((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (boolean)itemStack.hasFoil());
        }
        this.renderModelLists(bakedModel, itemStack, packedLight, packedOverlay, poseStack, vertexConsumer);
    }

    private boolean updateArmorStand(ItemStack itemStack) {
        EquipmentSlot equipmentSlot = ItemUtil.getEquipmentSlot(itemStack);
        if (!equipmentSlot.isArmor()) {
            return false;
        }
        if (armorStand == null) {
            Minecraft minecraft = Minecraft.getInstance();
            armorStand = (ArmorStand)EntityType.ARMOR_STAND.create((Level)minecraft.level);
            armorStand.setInvisible(true);
        }
        if (armorStand == null) {
            return false;
        }
        if (cachedArmorStandItem != Pair.of((Object)itemStack.getItem(), (Object)ItemUtil.getItemComponents(itemStack))) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                armorStand.setItemSlot(slot, ItemStack.EMPTY);
            }
            armorStand.setItemSlot(equipmentSlot, itemStack);
            cachedArmorStandItem = Pair.of((Object)itemStack.getItem(), (Object)ItemUtil.getItemComponents(itemStack));
        }
        return true;
    }

    private Entity getEntityFromItem(ItemStack itemStack) {
        Entity collectedEntity = null;
        List<Entity> collectedEntities = EntityCollector.collectEntitiesFromItem(itemStack);
        if (!collectedEntities.isEmpty()) {
            collectedEntity = collectedEntities.get(0);
        }
        return collectedEntity;
    }

    private boolean updateEntity(ItemStack itemStack) {
        Pair entityItem = Pair.of((Object)itemStack.getItem(), (Object)ItemUtil.getItemComponents(itemStack));
        if (entity == null || cachedEntityItem != entityItem) {
            entity = this.getEntityFromItem(itemStack);
            cachedEntityItem = entityItem;
        }
        return entity != null;
    }

    private boolean updateHorseArmor(ItemStack horseArmorItem) {
        AnimalArmorItem animalArmor;
        Item item = horseArmorItem.getItem();
        if (!(item instanceof AnimalArmorItem) || (animalArmor = (AnimalArmorItem)item).getBodyType() != AnimalArmorItem.BodyType.EQUESTRIAN) {
            return false;
        }
        if (horse == null) {
            Minecraft minecraft = Minecraft.getInstance();
            horse = (Horse)EntityType.HORSE.create((Level)minecraft.level);
            horse.setInvisible(true);
        }
        if (horse == null) {
            return false;
        }
        if (cachedHorseArmorItem != Pair.of((Object)horseArmorItem.getItem(), (Object)ItemUtil.getItemComponents(horseArmorItem))) {
            horse.setBodyArmorItem(horseArmorItem);
            cachedHorseArmorItem = Pair.of((Object)horseArmorItem.getItem(), (Object)ItemUtil.getItemComponents(horseArmorItem));
        }
        return true;
    }

    private boolean updateWolfArmor(ItemStack wolfArmorItem) {
        AnimalArmorItem animalArmor;
        Item item = wolfArmorItem.getItem();
        if (!(item instanceof AnimalArmorItem) || (animalArmor = (AnimalArmorItem)item).getBodyType() != AnimalArmorItem.BodyType.CANINE) {
            return false;
        }
        if (wolf == null) {
            Minecraft minecraft = Minecraft.getInstance();
            wolf = (Wolf)EntityType.WOLF.create((Level)minecraft.level);
            wolf.setInvisible(true);
        }
        if (wolf == null) {
            return false;
        }
        if (cachedWolfArmorItem != Pair.of((Object)wolfArmorItem.getItem(), (Object)ItemUtil.getItemComponents(wolfArmorItem))) {
            wolf.setBodyArmorItem(wolfArmorItem);
            cachedWolfArmorItem = Pair.of((Object)wolfArmorItem.getItem(), (Object)ItemUtil.getItemComponents(wolfArmorItem));
        }
        return true;
    }

    private ModelBounds boundsFromVertices(Set<Vector3f> vertices) {
        Vector3f center = new Vector3f();
        float radius = 0.0f;
        float height = 0.0f;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (Vector3f vertex : vertices) {
            minX = Math.min(minX, vertex.x);
            minY = Math.min(minY, vertex.y);
            minZ = Math.min(minZ, vertex.z);
            maxX = Math.max(maxX, vertex.x);
            maxY = Math.max(maxY, vertex.y);
            maxZ = Math.max(maxZ, vertex.z);
        }
        center = new Vector3f((minX + maxX) / 2.0f, (minY + maxY) / 2.0f, (minZ + maxZ) / 2.0f);
        height = maxY - minY;
        for (Vector3f vertex : vertices) {
            radius = Math.max(radius, (float)Math.sqrt((vertex.x - center.x) * (vertex.x - center.x) + (vertex.z - center.z) * (vertex.z - center.z)));
        }
        return new ModelBounds(center, height, radius);
    }

    private ModelBounds getModelBounds(ItemStack itemStack, ItemDisplayContext displayContext, boolean leftHanded, PoseStack poseStack, Quaternionf rotation, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BakedModel bakedModel) {
        Pair key = Pair.of((Object)itemStack.getItem(), (Object)ItemUtil.getItemComponents(itemStack));
        if (!modelBoundsCache.containsKey(key)) {
            VertexCollector vertexCollector = VertexCollector.create();
            this.renderModelInternal(itemStack, displayContext, leftHanded, poseStack, rotation, vertexCollector, packedLight, packedOverlay, bakedModel, b -> b.getVertices().isEmpty());
            modelBoundsCache.put((Pair<Item, DataComponentMap>)key, this.boundsFromVertices(vertexCollector.getVertices()));
        }
        return modelBoundsCache.get(key);
    }

    public void renderDetailModelIntoGUI(ItemStack stack, int x, int y, Quaternionf rotation, GuiGraphics graphics) {
        Minecraft minecraft = Minecraft.getInstance();
        BakedModel bakedModel = minecraft.getItemRenderer().getModel(stack, (Level)minecraft.level, (LivingEntity)minecraft.player, 0);
        try {
            this.renderGuiModel(stack, x, y, rotation, bakedModel, graphics);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Item being rendered");
            crashReportCategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
            crashReportCategory.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
            crashReportCategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
            throw new ReportedException(crashReport);
        }
    }

    public void renderItemModelIntoGUIWithAlpha(GuiGraphics graphics, ItemStack stack, int x, int y, float alpha) {
        boolean flatLighting;
        BakedModel bakedModel = this.minecraft.getItemRenderer().getModel(stack, null, null, 0);
        RenderTarget lastFrameBuffer = this.minecraft.getMainRenderTarget();
        iconFrameBuffer.clear(Minecraft.ON_OSX);
        iconFrameBuffer.bindWrite(true);
        Matrix4f matrix = new Matrix4f();
        matrix.setOrtho(0.0f, (float)CustomItemRenderer.iconFrameBuffer.width, (float)CustomItemRenderer.iconFrameBuffer.height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)matrix, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        modelViewStack.translate(48.0f, 48.0f, -2000.0f);
        modelViewStack.scale(96.0f, 96.0f, 96.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = graphics.bufferSource();
        boolean bl = flatLighting = !bakedModel.usesBlockLight();
        if (flatLighting) {
            Lighting.setupForFlatItems();
        }
        this.render(stack, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        graphics.flush();
        if (flatLighting) {
            Lighting.setupFor3DItems();
        }
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        if (lastFrameBuffer != null) {
            lastFrameBuffer.bindWrite(true);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
            RenderSystem.setShaderTexture((int)0, (int)iconFrameBuffer.getColorTextureId());
            GuiHelper.blit(graphics.pose(), x, y, 16, 16, 0.0f, 0.0f, CustomItemRenderer.iconFrameBuffer.width, CustomItemRenderer.iconFrameBuffer.height, CustomItemRenderer.iconFrameBuffer.width, CustomItemRenderer.iconFrameBuffer.height);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.flush();
            iconFrameBuffer.unbindRead();
        } else {
            iconFrameBuffer.unbindWrite();
        }
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        super.onResourceManagerReload(resourceManager);
        modelBoundsCache.clear();
    }

    static {
        quadDirections.add(null);
    }

    private record ModelBounds(Vector3f center, float height, float radius) {
    }
}

