/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.item.foodcontainer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import team.creative.creativecore.common.util.type.list.TupleList;
import team.creative.solonion.api.FoodPlayerData;
import team.creative.solonion.api.OnionFoodContainer;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.item.foodcontainer.FoodContainerProvider;
import team.creative.solonion.common.mod.OriginsManager;

public class FoodContainerItem
extends Item
implements OnionFoodContainer {
    private String displayName;
    public final int nslots;

    public FoodContainerItem(int nslots, String displayName) {
        super(new Item.Properties().stacksTo(1).setNoRepair().food(new FoodProperties.Builder().build()));
        this.displayName = displayName;
        this.nslots = nslots;
    }

    public InteractionResult useOn(UseOnContext context) {
        IItemHandler handler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(context.getLevel(), context.getClickedPos(), null, null, (Object)context.getClickedFace());
        if (handler == null) {
            return super.useOn(context);
        }
        ItemStackHandler inv = FoodContainerItem.getInventory(context.getItemInHand());
        if (inv == null) {
            return super.useOn(context);
        }
        TupleList bestStacks = new TupleList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty() || stack.getFoodProperties((LivingEntity)context.getPlayer()) == null || !OriginsManager.isEdible(context.getPlayer(), stack)) continue;
            for (int j = 0; j < inv.getSlots(); ++j) {
                ItemStack toBeStacked = inv.getStackInSlot(j);
                if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)toBeStacked) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)toBeStacked)) continue;
                int maxStackSize = Math.min(stack.getMaxStackSize(), inv.getSlotLimit(j));
                if (!toBeStacked.isEmpty() && toBeStacked.getCount() < maxStackSize) {
                    toBeStacked.grow(handler.extractItem(i, maxStackSize - toBeStacked.getCount(), false).getCount());
                }
                if ((stack = handler.getStackInSlot(i)).isEmpty()) break;
            }
            bestStacks.add((Object)SOLOnion.CONFIG.getDiversity((LivingEntity)context.getPlayer(), stack), (Object)i);
        }
        bestStacks.sort(Comparator.comparingDouble(x -> (Double)x.key));
        Iterator i = bestStacks.values().iterator();
        while (i.hasNext()) {
            int slot = (Integer)i.next();
            ItemStack stack = handler.extractItem(slot, handler.getStackInSlot(slot).getCount(), false);
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)stack, (boolean)false);
            if (result.isEmpty()) continue;
            handler.insertItem(slot, result, false);
            break;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(inv.getSlots());
        for (int i2 = 0; i2 < inv.getSlots(); ++i2) {
            stacks.add(inv.getStackInSlot(i2));
        }
        context.getItemInHand().set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(stacks));
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide && player.isCrouching()) {
            player.openMenu((MenuProvider)new FoodContainerProvider(this.displayName), player.blockPosition());
        }
        if (!player.isCrouching()) {
            return this.processRightClick(world, player, hand);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    private InteractionResultHolder<ItemStack> processRightClick(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (FoodContainerItem.isInventoryEmpty(player, stack)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.canEat(false)) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private static boolean isInventoryEmpty(Player player, ItemStack container) {
        ItemStackHandler handler = FoodContainerItem.getInventory(container);
        if (handler == null) {
            return true;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty() || stack.getFoodProperties((LivingEntity)player) == null || !OriginsManager.isEdible(player, stack)) continue;
            return false;
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.solonion.container.open", (Object[])new Object[]{Component.keybind((String)"key.sneak"), Component.keybind((String)"key.use")}));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    @Nullable
    public static ItemStackHandler getInventory(ItemStack bag) {
        return (ItemStackHandler)bag.getCapability(Capabilities.ItemHandler.ITEM);
    }

    @Override
    public ItemStack getActualFood(Player player, ItemStack stack) {
        ItemStackHandler handler = FoodContainerItem.getInventory(stack);
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        int bestFoodSlot = FoodContainerItem.getBestFoodSlot(handler, player);
        if (bestFoodSlot < 0) {
            return ItemStack.EMPTY;
        }
        return handler.getStackInSlot(bestFoodSlot).copy();
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ItemStackHandler handler = FoodContainerItem.getInventory(stack);
        if (handler == null) {
            return stack;
        }
        int bestFoodSlot = FoodContainerItem.getBestFoodSlot(handler, player);
        if (bestFoodSlot < 0) {
            return stack;
        }
        ItemStack bestFood = handler.getStackInSlot(bestFoodSlot);
        ItemStack foodCopy = bestFood.copy();
        if (bestFood.getFoodProperties((LivingEntity)player) != null && !bestFood.isEmpty() && OriginsManager.isEdible(player, foodCopy)) {
            ItemStack result = bestFood.finishUsingItem(world, entity);
            if (result.getFoodProperties((LivingEntity)player) == null) {
                handler.setStackInSlot(bestFoodSlot, ItemStack.EMPTY);
                Player playerEntity = (Player)entity;
                if (!playerEntity.getInventory().add(result)) {
                    playerEntity.drop(result, false);
                }
            }
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(handler.getSlots());
            for (int i = 0; i < handler.getSlots(); ++i) {
                stacks.add(handler.getStackInSlot(i));
            }
            stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(stacks));
            if (!world.isClientSide) {
                EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)foodCopy, (int)0, (ItemStack)result);
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public static int getBestFoodSlot(ItemStackHandler handler, Player player) {
        FoodPlayerData foodList = SOLOnionAPI.getFoodCapability(player);
        double maxDiversity = -1.7976931348623157E308;
        int bestFoodSlot = -1;
        for (int i = 0; i < handler.getSlots(); ++i) {
            double diversityChange;
            ItemStack food = handler.getStackInSlot(i);
            if (food.getFoodProperties((LivingEntity)player) == null || food.isEmpty() || !OriginsManager.isEdible(player, food) || !((diversityChange = foodList.simulateEat((LivingEntity)player, food)) > maxDiversity)) continue;
            maxDiversity = diversityChange;
            bestFoodSlot = i;
        }
        return bestFoodSlot;
    }
}

