/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.SOLOnion;

public final class FoodListCommand {
    public static final String name = "solonion";

    public static ArgumentBuilder<CommandSourceStack, ?> withPlayerArgumentOrSender(ArgumentBuilder<CommandSourceStack, ?> base, CommandWithPlayer command) {
        String target = "target";
        return base.executes(context -> command.run((CommandContext<CommandSourceStack>)context, (Player)((CommandSourceStack)context.getSource()).getPlayerOrException())).then(Commands.argument((String)target, (ArgumentType)EntityArgument.player()).executes(context -> command.run((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.getPlayer((CommandContext)context, (String)target))));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> withNoArgument(ArgumentBuilder<CommandSourceStack, ?> base, CommandWithoutArgs command) {
        return base.executes(context -> command.run((CommandContext<CommandSourceStack>)context));
    }

    public static int displayDiversity(CommandContext<CommandSourceStack> context, Player target) {
        boolean isOp = ((CommandSourceStack)context.getSource()).hasPermission(2);
        boolean isTargetingSelf = FoodListCommand.isTargetingSelf(context, target);
        if (!isOp && !isTargetingSelf) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)FoodListCommand.localizedComponent("no_permissions", new Object[0]));
            return -1;
        }
        double diversity = SOLOnionAPI.getFoodCapability(target).foodDiversity((LivingEntity)target);
        MutableComponent feedback = FoodListCommand.localizedComponent("diversity_feedback", diversity);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), feedback);
        return 1;
    }

    public static int syncFoodList(CommandContext<CommandSourceStack> context, Player target) {
        SOLOnion.EVENT.syncFoodList(target);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), FoodListCommand.localizedComponent("sync.success", new Object[0]));
        System.out.println(target.getMaxHealth());
        return 1;
    }

    public static int clearFoodList(CommandContext<CommandSourceStack> context, Player target) {
        boolean isOp = ((CommandSourceStack)context.getSource()).hasPermission(2);
        boolean isTargetingSelf = FoodListCommand.isTargetingSelf(context, target);
        if (!isOp && !isTargetingSelf) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)FoodListCommand.localizedComponent("no_permissions", new Object[0]));
            return -1;
        }
        SOLOnionAPI.getFoodCapability(target).clearAll();
        SOLOnion.EVENT.updatePlayerBenefits(target);
        SOLOnion.EVENT.syncFoodList(target);
        MutableComponent feedback = FoodListCommand.localizedComponent("clear.success", new Object[0]);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), feedback);
        if (!isTargetingSelf) {
            target.displayClientMessage((Component)FoodListCommand.applyFeedbackStyle(feedback), true);
        }
        return 1;
    }

    public static int resetPlayerOrigin(CommandContext<CommandSourceStack> context, Player target) {
        boolean isOp = ((CommandSourceStack)context.getSource()).hasPermission(2);
        boolean isTargetingSelf = FoodListCommand.isTargetingSelf(context, target);
        if (!isOp && !isTargetingSelf) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)FoodListCommand.localizedComponent("no_permissions", new Object[0]));
            return -1;
        }
        MutableComponent feedback = ModList.get().isLoaded("origins") ? FoodListCommand.localizedComponent("origin.invalidated", new Object[0]) : FoodListCommand.localizedComponent("origin.inapplicable", new Object[0]);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), feedback);
        if (!isTargetingSelf) {
            target.displayClientMessage((Component)FoodListCommand.applyFeedbackStyle(feedback), true);
        }
        return 1;
    }

    public static int resetAllOrigins(CommandContext<CommandSourceStack> context) {
        boolean isOp = ((CommandSourceStack)context.getSource()).hasPermission(2);
        if (!isOp) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)FoodListCommand.localizedComponent("no_permissions", new Object[0]));
            return -1;
        }
        MutableComponent feedback = ModList.get().isLoaded("origins") ? FoodListCommand.localizedComponent("origin.cleared", new Object[0]) : FoodListCommand.localizedComponent("origin.inapplicable", new Object[0]);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), feedback);
        return 1;
    }

    public static void sendFeedback(CommandSourceStack source, MutableComponent message) {
        source.sendSuccess(() -> FoodListCommand.applyFeedbackStyle(message), true);
    }

    public static MutableComponent applyFeedbackStyle(MutableComponent text) {
        return text.withStyle(style -> style.applyFormat(ChatFormatting.DARK_AQUA));
    }

    public static boolean isTargetingSelf(CommandContext<CommandSourceStack> context, Player target) {
        return target.is(Objects.requireNonNull(((CommandSourceStack)context.getSource()).getEntity()));
    }

    public static MutableComponent localizedComponent(String path, Object ... args) {
        return Component.translatable((String)("command." + FoodListCommand.localizationPath(path)), (Object[])args);
    }

    public static String localizationPath(String path) {
        return "solonion." + path;
    }

    @FunctionalInterface
    public static interface CommandWithPlayer {
        public int run(CommandContext<CommandSourceStack> var1, Player var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface CommandWithoutArgs {
        public int run(CommandContext<CommandSourceStack> var1);
    }
}

