/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import java.util.HashMap;
import java.util.Map;
import team.creative.solonion.common.benefit.Benefit;
import team.creative.solonion.common.benefit.BenefitType;

public class BenefitStack {
    private final HashMap<BenefitType, Object> typeStack = new HashMap();

    public BenefitStack() {
    }

    public BenefitStack(Iterable<Benefit> benefits) {
        this.addAll(benefits);
    }

    public void add(Benefit benefit) {
        BenefitType type = BenefitType.getType(benefit);
        Object stack = this.typeStack.get(type);
        if (stack == null) {
            stack = type.createStack();
            this.typeStack.put(type, stack);
        }
        type.addToStack(benefit, stack);
    }

    public void addAll(Iterable<Benefit> benefits) {
        for (Benefit benefit : benefits) {
            this.add(benefit);
        }
    }

    public boolean isEmpty() {
        for (Map.Entry<BenefitType, Object> entry : this.typeStack.entrySet()) {
            if (entry.getKey().isEmpty(entry.getValue())) continue;
            return false;
        }
        return false;
    }

    public <T> T get(BenefitType<?, T, ?> type) {
        return (T)this.typeStack.get(type);
    }
}

