/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom;

import de.keksuccino.justzoom.JustZoom;
import de.keksuccino.justzoom.util.AbstractOptions;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsScreen
extends Screen {
    @Nullable
    protected Screen parent;

    public OptionsScreen(@Nullable Screen parent) {
        super((Component)Component.translatable((String)"justzoom.options"));
        this.parent = parent;
    }

    protected void init() {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        StringWidget titleWidget = (StringWidget)this.addRenderableWidget((GuiEventListener)new StringWidget(this.getTitle(), this.font));
        titleWidget.setX(centerX - titleWidget.getWidth() / 2);
        titleWidget.setY(20);
        this.addFloatInput(JustZoom.getOptions().baseZoomFactor, centerY - 72, "justzoom.options.base_zoom_modifier");
        this.addFloatInput(JustZoom.getOptions().zoomInPerScroll, centerY - 47, "justzoom.options.zoom_in_change_modifier_per_scroll");
        this.addFloatInput(JustZoom.getOptions().zoomOutPerScroll, centerY - 22, "justzoom.options.zoom_out_change_modifier_per_scroll");
        this.addRenderableWidget((GuiEventListener)this.buildToggleButton(JustZoom.getOptions().smoothZoomInOut, centerY + 3, "justzoom.options.smooth_zoom_in_out"));
        this.addRenderableWidget((GuiEventListener)this.buildToggleButton(JustZoom.getOptions().smoothCameraOnZoom, centerY + 28, "justzoom.options.smooth_camera_movement_on_zoom"));
        this.addRenderableWidget((GuiEventListener)this.buildToggleButton(JustZoom.getOptions().normalizeMouseSensitivityOnZoom, centerY + 53, "justzoom.options.normalize_mouse_sensitivity_on_zoom"));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(centerX - 75, this.height - 40, 150, 20).build());
    }

    protected Button buildToggleButton(@NotNull AbstractOptions.Option<Boolean> option, int y, @NotNull String labelBaseKey) {
        int centerX = this.width / 2;
        int buttonWidth = 200;
        MutableComponent enabled = Component.translatable((String)labelBaseKey, (Object[])new Object[]{Component.translatable((String)"justzoom.options.toggle.enabled").withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN))});
        MutableComponent disabled = Component.translatable((String)labelBaseKey, (Object[])new Object[]{Component.translatable((String)"justzoom.options.toggle.disabled").withStyle(Style.EMPTY.withColor(ChatFormatting.RED))});
        return Button.builder((Component)(option.getValue() != false ? enabled : disabled), arg_0 -> OptionsScreen.lambda$buildToggleButton$1(option, (Component)enabled, (Component)disabled, arg_0)).bounds(centerX - buttonWidth / 2, y, buttonWidth, 20).tooltip(Tooltip.create((Component)Component.translatable((String)(labelBaseKey + ".desc")))).build();
    }

    protected void addFloatInput(@NotNull AbstractOptions.Option<Float> option, int y, @NotNull String labelBaseKey) {
        int centerX = this.width / 2;
        StringWidget zoomOutPerScrollText = (StringWidget)this.addRenderableWidget((GuiEventListener)new StringWidget((Component)Component.translatable((String)labelBaseKey), this.font));
        zoomOutPerScrollText.setX(centerX - 5 - zoomOutPerScrollText.getWidth());
        Objects.requireNonNull(this.font);
        zoomOutPerScrollText.setY(y + 10 - 9 / 2);
        zoomOutPerScrollText.setTooltip(Tooltip.create((Component)Component.translatable((String)(labelBaseKey + ".desc"))));
        EditBox zoomOutPerScroll = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, centerX + 5, y, 150, 20, (Component)Component.translatable((String)labelBaseKey)));
        zoomOutPerScroll.setValue(String.valueOf(option.getValue()));
        zoomOutPerScroll.setResponder(s -> {
            if (MathUtils.isFloat((String)s)) {
                option.setValue(Float.valueOf(Float.parseFloat(s)));
            }
        });
        zoomOutPerScroll.setTooltip(Tooltip.create((Component)Component.translatable((String)(labelBaseKey + ".desc"))));
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    private static /* synthetic */ void lambda$buildToggleButton$1(AbstractOptions.Option option, Component enabled, Component disabled, Button button) {
        option.setValue((Boolean)option.getValue() == false);
        button.setMessage((Boolean)option.getValue() != false ? enabled : disabled);
    }
}

