/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class EntityUtils {
    public static void moveTowardsPosition(Entity entity, Vec3 targetPos, double speed) {
        Vec3 motion = targetPos.subtract(entity.position()).normalize().scale(speed);
        entity.setDeltaMovement(motion.x, motion.y, motion.z);
    }

    public static int getSlotWithItem(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (player.getInventory().getItem(i).getItem() != item) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getSlotsWithItem(Player player, Item item) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (player.getInventory().getItem(i).getItem() != item) continue;
            list.add(i);
            if (i != player.getInventory().getContainerSize()) continue;
            return list;
        }
        return list;
    }

    public static void addItem(Player player, ItemStack stack) {
        if (player.addItem(stack)) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        RandomSource random = level.getRandom();
        ItemEntity drop = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), stack);
        drop.setDeltaMovement((double)(MathUtils.randomFloat(random) * 0.15f), (double)(0.1f + random.nextFloat() * 0.2f), (double)(MathUtils.randomFloat(random) * 0.15f));
        drop.setPickUpDelay(20);
        level.addFreshEntity((Entity)drop);
    }

    public static EntityHitResult rayTraceEntity(Entity shooter, Predicate<? super Entity> filter, double distance) {
        Level world = shooter.level();
        Vec3 startVec = shooter.getEyePosition(1.0f);
        Vec3 endVec = shooter.getEyePosition(1.0f).add(shooter.getViewVector(1.0f).scale(distance));
        double d0 = distance * distance;
        Entity entity = null;
        Vec3 vector3d = null;
        for (Entity entity1 : world.getEntities(shooter, shooter.getBoundingBox().expandTowards(shooter.getViewVector(1.0f).scale(distance * distance)).inflate(1.0), filter)) {
            Vec3 vector3d1;
            double d1;
            AABB axisalignedbb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius());
            Optional optional = axisalignedbb.clip(startVec, endVec);
            if (axisalignedbb.contains(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.distanceToSqr(vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.getRootVehicle() == shooter.getRootVehicle() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vector3d);
    }

    private static ResourceLocation getAttributeId(ItemStack stack, Attribute attribute) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + "_" + BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute).getPath()));
    }

    public static void applyAttribute(LivingEntity entity, ItemStack stack, Holder<Attribute> attributeHolder, float value, AttributeModifier.Operation operation) {
        Attribute attribute = (Attribute)attributeHolder.value();
        ResourceLocation id = EntityUtils.getAttributeId(stack, attribute);
        AttributeInstance instance = entity.getAttribute(attributeHolder);
        if (instance == null || instance.hasModifier(id)) {
            return;
        }
        instance.addTransientModifier(new AttributeModifier(id, (double)value, operation));
    }

    public static void removeAttribute(LivingEntity entity, ItemStack stack, Holder<Attribute> attributeHolder, AttributeModifier.Operation operation) {
        Attribute attribute = (Attribute)attributeHolder.value();
        ResourceLocation id = EntityUtils.getAttributeId(stack, attribute);
        AttributeInstance instance = entity.getAttribute(attributeHolder);
        if (instance == null) {
            return;
        }
        if (!instance.hasModifier(id)) {
            return;
        }
        instance.removeModifier(new AttributeModifier(id, instance.getValue(), operation));
    }

    public static void resetAttribute(LivingEntity entity, ItemStack stack, Holder<Attribute> attributeHolder, float value, AttributeModifier.Operation operation) {
        EntityUtils.removeAttribute(entity, stack, attributeHolder, operation);
        EntityUtils.applyAttribute(entity, stack, attributeHolder, value, operation);
    }

    public static ItemStack findEquippedCurio(Entity entity, Item item) {
        if (!(entity instanceof Player)) {
            return ItemStack.EMPTY;
        }
        Player player = (Player)entity;
        Optional optional = CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player);
        if (optional.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)((ImmutableTriple)optional.get()).getRight();
    }

    public static int getExperienceForLevel(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public static int getTotalExperienceForLevel(int level) {
        int result = 0;
        for (int i = 0; i < level; ++i) {
            result += EntityUtils.getExperienceForLevel(i);
        }
        return result;
    }

    public static int getPlayerTotalExperience(Player player) {
        int result = player.totalExperience;
        for (int level = 0; level < player.experienceLevel; ++level) {
            result += EntityUtils.getExperienceForLevel(level);
        }
        return result;
    }

    public static boolean isAlliedTo(@Nullable Entity source, @Nullable Entity target) {
        OwnableEntity ownable;
        return source == null || target == null || source.isAlliedTo(target) || target.isAlliedTo(source) || target.getUUID().equals(source.getUUID()) || target instanceof OwnableEntity && (ownable = (OwnableEntity)target).getOwnerUUID() != null && ownable.getOwnerUUID().equals(source.getUUID());
    }

    public static boolean hurt(LivingEntity entity, DamageSource source, float amount) {
        LivingEntity sourceEntity;
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity && EntityUtils.isAlliedTo((Entity)(sourceEntity = (LivingEntity)entity2), (Entity)entity)) {
            return false;
        }
        return entity.hurt(source, amount);
    }

    public static List<ItemStack> getEquippedRelics(LivingEntity entity) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (!(entity instanceof Player)) {
            return items;
        }
        Player player = (Player)entity;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof IRelicItem)) continue;
            items.add(stack);
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            for (int i = 0; i < handler.getEquippedCurios().getSlots(); ++i) {
                ItemStack stack = handler.getEquippedCurios().getStackInSlot(i);
                if (!(stack.getItem() instanceof IRelicItem)) continue;
                items.add(stack);
            }
        });
        return items;
    }
}

