/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.sync;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncTargetPacket
implements CustomPacketPayload {
    private final int targeterId;
    private final int targetId;
    public static final CustomPacketPayload.Type<SyncTargetPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"target_path"));
    public static final StreamCodec<ByteBuf, SyncTargetPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SyncTargetPacket::getTargetId, (StreamCodec)ByteBufCodecs.INT, SyncTargetPacket::getTargeterId, SyncTargetPacket::new);

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Level level = Minecraft.getInstance().player.level();
            Entity patt0$temp = level.getEntity(this.targetId);
            if (patt0$temp instanceof ITargetableEntity) {
                ITargetableEntity targeter = (ITargetableEntity)patt0$temp;
                Entity patt1$temp = level.getEntity(this.targeterId);
                if (patt1$temp instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)patt1$temp;
                    targeter.setTarget(target);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public int getTargeterId() {
        return this.targeterId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncTargetPacket)) {
            return false;
        }
        SyncTargetPacket other = (SyncTargetPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTargeterId() != other.getTargeterId()) {
            return false;
        }
        return this.getTargetId() == other.getTargetId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SyncTargetPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTargeterId();
        result = result * 59 + this.getTargetId();
        return result;
    }

    public String toString() {
        return "SyncTargetPacket(targeterId=" + this.getTargeterId() + ", targetId=" + this.getTargetId() + ")";
    }

    public SyncTargetPacket(int targeterId, int targetId) {
        this.targeterId = targeterId;
        this.targetId = targetId;
    }
}

