/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.research;

import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketResearchHint
implements CustomPacketPayload {
    private final int container;
    private final int slot;
    private final String ability;
    private final int amount;
    public static final CustomPacketPayload.Type<PacketResearchHint> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"research_hint"));
    public static final StreamCodec<ByteBuf, PacketResearchHint> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketResearchHint::getContainer, (StreamCodec)ByteBufCodecs.INT, PacketResearchHint::getSlot, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketResearchHint::getAbility, (StreamCodec)ByteBufCodecs.INT, PacketResearchHint::getAmount, PacketResearchHint::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.player().level().isClientSide()) {
                return;
            }
            ServerPlayer player = (ServerPlayer)ctx.player();
            if (player.containerMenu.containerId != this.container) {
                PacketResearchHint.causeError((Player)player);
                return;
            }
            ItemStack stack = DescriptionUtils.gatherRelicStack((Player)player, this.slot);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                PacketResearchHint.causeError((Player)player);
                return;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            RandomSource random = player.getRandom();
            int cost = relic.getResearchHintCost(this.ability) * this.amount;
            if (player.experienceLevel < cost) {
                return;
            }
            player.giveExperienceLevels(-cost);
            this.research(stack, this.amount);
            if (relic.testAbilityResearch(stack, this.ability)) {
                relic.setAbilityResearched(stack, this.ability, true);
                player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)((SoundEvent)SoundRegistry.FINISH_RESEARCH.get())), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, random.nextLong()));
            } else {
                player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)((SoundEvent)SoundRegistry.CONNECT_STARS.get())), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 0.75f, 0.75f + random.nextFloat() * 0.5f, random.nextLong()));
            }
            try {
                player.containerMenu.getSlot(this.slot).set(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                PacketResearchHint.causeError((Player)player);
            }
        });
    }

    public void research(ItemStack stack, int amount) {
        Integer end;
        Integer start;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        Multimap<Integer, Integer> pattern = relic.getResearchData(this.ability).getLinks();
        Multimap<Integer, Integer> links = relic.getResearchLinks(stack, this.ability);
        int iteration = 0;
        for (Map.Entry entry : links.entries()) {
            start = (Integer)entry.getKey();
            if (pattern.containsEntry((Object)start, (Object)(end = (Integer)entry.getValue())) || pattern.containsEntry((Object)end, (Object)start)) continue;
            relic.removeResearchLink(stack, this.ability, start, end);
            if (++iteration < amount) continue;
            break;
        }
        iteration = 0;
        for (Map.Entry entry : pattern.entries()) {
            start = (Integer)entry.getKey();
            if (links.containsEntry((Object)start, (Object)(end = (Integer)entry.getValue())) || links.containsEntry((Object)end, (Object)start)) continue;
            relic.addResearchLink(stack, this.ability, start, end);
            if (++iteration < amount) continue;
            break;
        }
    }

    private static void causeError(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"info.relics.researching.wrong_container").withStyle(ChatFormatting.RED), false);
        player.closeContainer();
    }

    public int getContainer() {
        return this.container;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getAbility() {
        return this.ability;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketResearchHint)) {
            return false;
        }
        PacketResearchHint other = (PacketResearchHint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainer() != other.getContainer()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        String this$ability = this.getAbility();
        String other$ability = other.getAbility();
        return !(this$ability == null ? other$ability != null : !this$ability.equals(other$ability));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PacketResearchHint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainer();
        result = result * 59 + this.getSlot();
        result = result * 59 + this.getAmount();
        String $ability = this.getAbility();
        result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
        return result;
    }

    public String toString() {
        return "PacketResearchHint(container=" + this.getContainer() + ", slot=" + this.getSlot() + ", ability=" + this.getAbility() + ", amount=" + this.getAmount() + ")";
    }

    public PacketResearchHint(int container, int slot, String ability, int amount) {
        this.container = container;
        this.slot = slot;
        this.ability = ability;
        this.amount = amount;
    }
}

