/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.feet.SpringyBootItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public class BlockMixin {
    @Inject(method={"fallOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void onEntityFall(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance, CallbackInfo ci) {
        SpringyBootItem relic;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.SPRINGY_BOOT.get());
        Item item = stack.getItem();
        if (!(item instanceof SpringyBootItem) || !(relic = (SpringyBootItem)item).isAbilityTicking(stack, "bounce")) {
            return;
        }
        Vec3 motion = player.getKnownMovement();
        double speed = motion.multiply(0.0, 1.0, 0.0).y();
        if (speed > -0.5) {
            return;
        }
        player.causeFallDamage(fallDistance, 0.0f, level.damageSources().fall());
        ci.cancel();
    }

    @Inject(method={"updateEntityAfterFallOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void onEntityFall(BlockGetter getter, Entity entity, CallbackInfo ci) {
        SpringyBootItem relic;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.SPRINGY_BOOT.get());
        Item item = stack.getItem();
        if (!(item instanceof SpringyBootItem) || !(relic = (SpringyBootItem)item).isAbilityTicking(stack, "bounce")) {
            return;
        }
        Vec3 motion = player.getKnownMovement();
        double speed = motion.multiply(0.0, 1.0, 0.0).y();
        if (speed > -0.5) {
            return;
        }
        speed = Math.abs(speed);
        double power = relic.getStatValue(stack, "bounce", "power");
        player.setDeltaMovement(motion.multiply(1.0, -power, 1.0));
        Level level = player.getCommandSenderWorld();
        RandomSource random = level.getRandom();
        level.playSound(player, player.blockPosition(), (SoundEvent)SoundRegistry.SPRING_BOING.get(), SoundSource.PLAYERS, (float)Math.min(2.0, 0.25 + speed * 0.5), (float)Math.max((double)0.1f, 2.0 - speed * 0.75));
        float i = 0.0f;
        while ((double)i < speed * 3.0) {
            level.addParticle((ParticleOptions)ParticleTypes.CLOUD, player.getX(), player.getY(), player.getZ(), (double)MathUtils.randomFloat(random) * speed * (double)0.15f, 0.0, (double)MathUtils.randomFloat(random) * speed * (double)0.15f);
            i += 0.1f;
        }
        ci.cancel();
    }
}

