/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.level;

import com.google.common.base.Suppliers;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.init.LootCodecRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class RelicLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<RelicLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> RelicLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, RelicLootModifier::new)));
    public static final Multimap<String, Pair<IRelicItem, Float>> LOOT_TABLES = LinkedHashMultimap.create();

    public RelicLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String lootId = context.getQueriedLootTableId().toString();
        for (Pair entry : LOOT_TABLES.get((Object)lootId)) {
            if (!(context.getRandom().nextFloat() <= ((Float)entry.getValue()).floatValue())) continue;
            generatedLoot.add((Object)((IRelicItem)entry.getKey()).getItem().getDefaultInstance());
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)LootCodecRegistry.RELIC_LOOT.get();
    }

    public static void processRelicCache(IRelicItem relic) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        for (String key : LOOT_TABLES.keys()) {
            LOOT_TABLES.get((Object)key).removeIf(pair -> ((IRelicItem)pair.getKey()).equals(relic));
        }
        for (Map.Entry<String, Float> entry : relic.getLootData().getCollection().getEntries().entrySet()) {
            for (ResourceLocation lootTable : server.reloadableRegistries().getKeys(Registries.LOOT_TABLE)) {
                boolean isValid;
                String id = lootTable.toString();
                String pattern = entry.getKey();
                Float chance = entry.getValue();
                try {
                    isValid = id.matches(pattern);
                }
                catch (PatternSyntaxException exception) {
                    isValid = id.equals(pattern);
                }
                if (!isValid) continue;
                LOOT_TABLES.put((Object)id, (Object)Pair.of((Object)relic, (Object)chance));
            }
        }
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onServerStarted(ServerStartedEvent event) {
            if (!LOOT_TABLES.isEmpty()) {
                return;
            }
            for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof IRelicItem)) continue;
                IRelicItem relic = (IRelicItem)v;
                RelicLootModifier.processRelicCache(relic);
            }
        }
    }
}

