/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class JellyfishNecklaceItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("unsinkable").maxLevel(0).build()).ability(AbilityData.builder("shock").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder("damage").icon(StatIcons.DEALT_DAMAGE).initialValue(0.5, 2.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability(AbilityData.builder("paralysis").requiredLevel(5).stat(StatData.builder("duration").icon(StatIcons.DURATION).initialValue(0.5, 1.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(LootCollections.AQUATIC).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.isEyeInFluid(FluidTags.WATER)) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.GRAVITY, -1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.GRAVITY, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        Level level = player.getCommandSenderWorld();
        if (!player.isSpectator() && this.isAbilityTicking(stack, "shock")) {
            for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox())) {
                if (entity == player || !EntityUtils.hurt(entity, level.damageSources().playerAttack(player), (float)this.getStatValue(stack, "shock", "damage"))) continue;
                this.spreadRelicExperience((LivingEntity)player, stack, 1);
                if (!this.isAbilityUnlocked(stack, "paralysis")) continue;
                entity.addEffect(new MobEffectInstance(EffectRegistry.PARALYSIS, (int)Math.round(this.getStatValue(stack, "paralysis", "duration") * 20.0), 0));
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Holder<Attribute>)Attributes.GRAVITY, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        matrixStack.scale(0.5f, 0.5f, 0.5f);
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.scale(2.0f, 2.0f, 2.0f);
        matrixStack.popPose();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition bone = mesh.getRoot().addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 0.0f, -4.15f, 16.0f, 7.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        bone.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(10, 16).addBox(-0.675f, 0.575f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.9708f, (float)8.2331f, (float)-4.6f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        bone.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(10, 16).addBox(0.0f, -2.5f, -0.475f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.9708f, (float)8.2331f, (float)-4.6f, (float)0.0f, (float)0.0f, (float)1.5708f));
        bone.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(10, 16).addBox(1.5f, -2.25f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.9708f, (float)8.2331f, (float)-4.6f, (float)0.0f, (float)0.0f, (float)0.7854f));
        bone.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(10, 16).addBox(-1.0104f, 0.5429f, -0.55f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.225f)), PartPose.offsetAndRotation((float)0.0354f, (float)7.1821f, (float)-4.575f, (float)0.0f, (float)0.0f, (float)-0.004f));
        bone.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(1, 16).addBox(-1.5104f, -2.4571f, -1.05f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0354f, (float)7.6821f, (float)-4.575f, (float)0.0f, (float)0.0f, (float)-0.004f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }
}

