/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedCurioModel;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class SpringyBootItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("bounce").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder("power").icon(StatIcons.REFLECT).initialValue(0.25, 0.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value * 100.0, 1)).build()).research(ResearchData.builder().star(0, 6, 8).star(1, 16, 10).star(2, 6, 12).star(3, 16, 14).star(4, 6, 16).star(5, 16, 18).star(6, 6, 20).star(7, 16, 22).star(8, 6, 24).link(0, 1).link(1, 2).link(2, 3).link(3, 4).link(4, 5).link(5, 6).link(6, 7).link(7, 8).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-7711216).borderBottom(-14199548).textured(true).build()).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).entry(LootCollections.VILLAGE).build()).build();
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        Level level = player.level();
        if (ability.equals("bounce") && stage == CastStage.START && player.onGround()) {
            Vec3 motion = player.getKnownMovement();
            double speed = this.getStatValue(stack, "bounce", "power") * 1.25;
            player.setDeltaMovement(motion.x, speed, motion.z);
            RandomSource random = level.getRandom();
            level.playSound(player, player.blockPosition(), (SoundEvent)SoundRegistry.SPRING_BOING.get(), SoundSource.PLAYERS, (float)Math.min(2.0, 0.25 + speed * 0.5), (float)Math.max((double)0.1f, 2.0 - speed * 0.75));
            float i = 0.0f;
            while ((double)i < speed * 3.0) {
                level.addParticle((ParticleOptions)ParticleTypes.CLOUD, player.getX(), player.getY(), player.getZ(), (double)MathUtils.randomFloat(random) * speed * (double)0.15f, (double)(random.nextFloat() * 0.1f), (double)MathUtils.randomFloat(random) * speed * (double)0.15f);
                i += 0.1f;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CurioModel getModel(ItemStack stack) {
        return new SidedCurioModel(stack.getItem());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        if (!(model instanceof SidedCurioModel)) {
            return;
        }
        SidedCurioModel sidedModel = (SidedCurioModel)model;
        sidedModel.setSlot(slotContext.index());
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        sidedModel.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        sidedModel.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{sidedModel});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        sidedModel.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition right_leg = mesh.getRoot().addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(40, 4).addBox(-2.5f, 5.25f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.305f)).texOffs(0, 10).addBox(-2.5f, 5.25f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 22).addBox(-2.5f, 12.25f, -5.5f, 5.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(20, 16).addBox(-2.5f, 8.25f, -5.5f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(20, 0).addBox(-2.5f, 8.25f, -5.5f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-1.0f, (float)11.75f, (float)2.5f));
        right_leg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(2, 22).addBox(3.5f, -1.0f, 1.52f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.001f)).texOffs(0, 22).addBox(10.5f, -1.0f, 1.52f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.001f)).texOffs(20, 10).addBox(3.5f, -1.0f, -1.48f, 7.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)8.25f, (float)1.4f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = mesh.getRoot().addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(40, 4).addBox(-2.5f, 5.25f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.305f)).texOffs(0, 10).addBox(-2.5f, 5.25f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 22).addBox(-2.5f, 12.25f, -5.5f, 5.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(20, 16).addBox(-2.5f, 8.25f, -5.5f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(20, 0).addBox(-2.5f, 8.25f, -5.5f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-1.0f, (float)11.75f, (float)2.5f));
        left_leg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(2, 22).addBox(3.5f, -1.0f, 1.52f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.001f)).texOffs(0, 22).addBox(10.5f, -1.0f, 1.52f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.001f)).texOffs(20, 10).addBox(3.5f, -1.0f, -1.48f, 7.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)8.25f, (float)1.4f, (float)0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_leg", "left_leg"});
    }
}

