/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.api.events.common.EntityBlockSpeedFactorEvent;
import it.hurts.sskirillss.relics.api.events.common.LivingSlippingEvent;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import top.theillusivec4.curios.api.SlotContext;

public class RollerSkatesItem
extends RelicItem {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("skating").stat(StatData.builder("speed").icon(StatIcons.SPEED).initialValue(0.001, 0.005).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0 * 100.0)).build()).stat(StatData.builder("duration").icon(StatIcons.DURATION).initialValue(15.0, 35.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value / 5.0, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(LootCollections.VILLAGE).entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int duration = (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0);
        if (player.isSprinting() && !player.isShiftKeyDown() && !player.isInWater() && !player.isInLava()) {
            if (player.tickCount % 20 == 0) {
                this.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
            if ((double)duration < this.getStatValue(stack, "skating", "duration") && player.tickCount % 4 == 0) {
                stack.set(DataComponentRegistry.CHARGE, (Object)(duration + 1));
            }
        } else if (duration > 0) {
            stack.set(DataComponentRegistry.CHARGE, (Object)(--duration));
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        if (duration > 0) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, (float)((double)duration * this.getStatValue(stack, "skating", "speed")), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.STEP_HEIGHT, 0.6f, AttributeModifier.Operation.ADD_VALUE);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.STEP_HEIGHT, AttributeModifier.Operation.ADD_VALUE);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.STEP_HEIGHT, AttributeModifier.Operation.ADD_VALUE);
    }

    @EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingSlipping(LivingSlippingEvent event) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).isInWater() || player.isFallFlying()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ROLLER_SKATES.get());
            if (stack.isEmpty()) {
                return;
            }
            event.setFriction(1.075f);
        }

        @SubscribeEvent
        public static void onSpeedFactor(EntityBlockSpeedFactorEvent event) {
            Player player;
            Entity entity = event.getEntity();
            if (!(entity instanceof Player) || (player = (Player)entity).isInWater() || player.isFallFlying()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ROLLER_SKATES.get());
            if (stack.isEmpty()) {
                return;
            }
            event.setSpeedFactor(1.0f);
        }
    }
}

