/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SporeEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> STUCK = SynchedEntityData.defineId(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.defineId(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public void setSize(float amount) {
        this.getEntityData().set(SIZE, (Object)Float.valueOf(amount));
    }

    public float getSize() {
        return ((Float)this.getEntityData().get(SIZE)).floatValue();
    }

    public void setStuck(boolean value) {
        this.getEntityData().set(STUCK, (Object)value);
    }

    public boolean isStuck() {
        return (Boolean)this.getEntityData().get(STUCK);
    }

    public void setLifetime(int amount) {
        this.getEntityData().set(LIFETIME, (Object)amount);
    }

    public int getLifetime() {
        return (Integer)this.getEntityData().get(LIFETIME);
    }

    public void setStack(ItemStack stack) {
        this.getEntityData().set(STACK, (Object)stack);
    }

    public ItemStack getStack() {
        return (ItemStack)this.getEntityData().get(STACK);
    }

    public SporeEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        Level level;
        super.tick();
        ItemStack stack = this.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            this.discard();
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        if (this.isStuck()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        if (!(level = this.level()).isClientSide()) {
            if (this.isStuck()) {
                this.setLifetime(this.getLifetime() + 1);
            }
            if ((double)this.getLifetime() > relic.getStatValue(stack, "spore", "duration") * 20.0) {
                this.discard();
            }
        }
        RandomSource random = level.getRandom();
        double inlinedSize = Math.pow(Math.log10(1.0f + this.getSize()), 0.3333333333333333);
        if (this.isStuck()) {
            ParticleUtils.createBall(ParticleUtils.constructSimpleSpark(new Color(random.nextInt(200), 255, 0), (float)(inlinedSize * 0.25), 40, 0.95f), this.position().add(0.0, inlinedSize / 6.0, 0.0), level, 0, (float)(inlinedSize * (double)0.025f));
        } else {
            level.addParticle(ParticleUtils.constructSimpleSpark(new Color(random.nextInt(200), 255, 0), (float)(inlinedSize * 0.25), 40, 0.9f), this.getX(), this.getY() + inlinedSize / 6.0, this.getZ(), (double)(MathUtils.randomFloat(random) * 0.025f), (double)(MathUtils.randomFloat(random) * 0.025f), (double)(MathUtils.randomFloat(random) * 0.025f));
        }
        Entity entity = this.getOwner();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isStuck()) {
            for (LivingEntity entity2 : level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox())) {
                if (entity2.getStringUUID().equals(player.getStringUUID())) continue;
                this.setLifetime((int)Math.max((long)this.getLifetime(), Math.round(relic.getStatValue(stack, "spore", "duration") * 20.0) - 20L));
                break;
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.setStuck(true);
    }

    public void onRemovedFromLevel() {
        ItemStack stack = this.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        this.level().playSound(null, this.blockPosition(), SoundEvents.PUFFER_FISH_BLOW_UP, SoundSource.MASTER, 1.0f, 1.0f + this.random.nextFloat());
        double inlinedSize = Math.pow(Math.log10(1.0f + this.getSize()), 0.3333333333333333);
        ParticleUtils.createBall(ParticleUtils.constructSimpleSpark(new Color(100 + this.level().getRandom().nextInt(50), 255, 0), (float)(inlinedSize * (double)0.35f), 40, 0.9f), this.position().add(0.0, inlinedSize / 3.0, 0.0), this.level(), (int)Math.ceil(1.0 + inlinedSize), (float)(inlinedSize / 2.0));
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            RandomSource random = player.getRandom();
            for (LivingEntity entity2 : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(1.0 + Math.pow(Math.log10(1.0f + this.getSize()), 0.3333333333333333) / 2.0))) {
                if (entity2.getStringUUID().equals(player.getStringUUID()) || !EntityUtils.hurt(entity2, this.level().damageSources().thrown((Entity)this, (Entity)player), (float)((double)this.getSize() * relic.getStatValue(stack, "spore", "damage")))) continue;
                entity2.addEffect(new MobEffectInstance(MobEffects.POISON, 100));
                entity2.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100));
                entity2.addEffect(new MobEffectInstance(EffectRegistry.ANTI_HEAL, 100));
            }
            if (this.getSize() >= 1.0f) {
                int count = (int)Math.ceil(Math.pow(this.getSize(), relic.getStatValue(stack, "multiplying", "amount")));
                for (int i = 0; i < count && !((double)random.nextFloat() > relic.getStatValue(stack, "multiplying", "chance")); ++i) {
                    float mul = this.getBbHeight() / 1.5f;
                    float speed = 0.1f + random.nextFloat() * 0.2f;
                    Vec3 motion = new Vec3((double)(MathUtils.randomFloat(random) * speed), (double)speed, (double)(MathUtils.randomFloat(random) * speed));
                    SporeEntity spore = new SporeEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SPORE.get()), this.level());
                    spore.setOwner((Entity)player);
                    spore.setStack(stack);
                    spore.setDeltaMovement(motion);
                    spore.setPos(this.position().add(0.0, (double)mul, 0.0).add(motion.normalize().scale((double)mul)));
                    spore.setSize((float)((double)this.getSize() * relic.getStatValue(stack, "multiplying", "size")));
                    this.level().addFreshEntity((Entity)spore);
                    relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                }
            }
        }
        super.onRemovedFromLevel();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SIZE, (Object)Float.valueOf(0.5f));
        builder.define(LIFETIME, (Object)0);
        builder.define(STUCK, (Object)false);
        builder.define(STACK, (Object)ItemStack.EMPTY);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setSize(compound.getFloat("size"));
        this.setStuck(compound.getBoolean("stuck"));
        this.setLifetime(compound.getInt("lifetime"));
        this.setStack(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound("stack")));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("size", this.getSize());
        compound.putBoolean("stuck", this.isStuck());
        compound.putInt("lifetime", this.getLifetime());
        this.getStack().save((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("stack"));
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (SIZE.equals(pKey)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(pKey);
    }

    public EntityDimensions getDimensions(Pose pPose) {
        float inlinedSize = (float)Math.pow(Math.log10(1.0f + this.getSize()), 0.3333333333333333);
        return EntityDimensions.scalable((float)(inlinedSize / 2.0f), (float)(inlinedSize / 2.0f));
    }
}

