/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class ShadowSawEntity
extends ThrowableProjectile {
    private ItemStack stack = ItemStack.EMPTY;
    public boolean isReturning = false;

    public ShadowSawEntity(EntityType<? extends ShadowSawEntity> pEntityType, Level level) {
        super(pEntityType, level);
    }

    public ShadowSawEntity(ItemStack stack, LivingEntity owner) {
        super((EntityType)EntityRegistry.SHADOW_SAW.get(), owner.getCommandSenderWorld());
        this.setStack(stack);
    }

    public void tick() {
        Item item;
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.level().isClientSide() || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        if (this.tickCount >= 1200) {
            this.isReturning = true;
        }
        if (this.isReturning) {
            this.noPhysics = true;
            Entity entity = this.getOwner();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (this.position().distanceTo(player.position()) > (double)this.getBbWidth()) {
                    this.setDeltaMovement(player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0).subtract(this.position()).normalize().multiply(0.75, 0.75, 0.75));
                } else {
                    for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                        ItemStack stack = player.getInventory().getItem(i);
                        if (stack.getItem() != ItemRegistry.SHADOW_GLAIVE.get() || !((String)stack.getOrDefault(DataComponentRegistry.SAW, (Object)"")).equals(this.getStringUUID())) continue;
                        stack.set(DataComponentRegistry.CHARGE, (Object)8);
                        stack.set(DataComponentRegistry.SAW, (Object)"");
                        break;
                    }
                    this.discard();
                }
            } else {
                this.discard();
            }
        } else if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.75, 0.75, 0.75));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.05f, 0.0));
        }
        int speed = (int)Math.round(relic.getStatValue(this.stack, "saw", "speed"));
        if (this.tickCount % speed == 0) {
            float damage = (float)Math.max(relic.getStatValue(this.stack, "saw", "damage"), 0.1);
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.5))) {
                boolean mayContinue = false;
                Entity entity2 = this.getOwner();
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    if (EntityUtils.hurt(entity, this.level().damageSources().playerAttack(player), damage)) {
                        mayContinue = true;
                    }
                } else if (entity.hurt(this.level().damageSources().magic(), damage)) {
                    mayContinue = true;
                }
                if (!mayContinue) continue;
                entity.invulnerableTime = speed;
            }
        }
        ServerLevel serverLevel = (ServerLevel)this.level();
        double radius = 1.5;
        for (int i = 0; i < 5; ++i) {
            float angle = (float)(-(this.tickCount * 20 + i * 120)) * 0.0105f;
            double extraX = radius * (double)Mth.sin((float)((float)(Math.PI + (double)angle))) + this.getX();
            double extraZ = radius * (double)Mth.cos((float)angle) + this.getZ();
            serverLevel.sendParticles(ParticleUtils.constructSimpleSpark(new Color(200, 0, 255), 0.075f, 20, 0.95f), extraX, this.getY() + 0.25, extraZ, 1, 0.01, 0.01, 0.01, (double)0.025f);
        }
        serverLevel.sendParticles(ParticleUtils.constructSimpleSpark(new Color(102, 0, 255), 0.1f, 20, 0.9f), this.getX(), this.getY() + (double)0.3f, this.getZ(), 2, 0.25, 0.1, 0.25, (double)0.02f);
    }

    protected void onHitBlock(BlockHitResult pResult) {
        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

