/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DeathEssenceEntity
extends ThrowableProjectile
implements ITargetableEntity {
    private float damage;
    private LivingEntity target;
    private static final EntityDataAccessor<Float> DIRECTION_CHOICE = SynchedEntityData.defineId(DeathEssenceEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public DeathEssenceEntity(EntityType<? extends DeathEssenceEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        super.tick();
        if (this.target == null) {
            return;
        }
        int segments = 10;
        double dx = (this.getX() - this.xOld) / (double)segments;
        double dy = (this.getY() - this.yOld) / (double)segments;
        double dz = (this.getZ() - this.zOld) / (double)segments;
        for (int i = 0; i < segments; ++i) {
            this.level().addParticle(ParticleUtils.constructSimpleSpark(new Color(this.random.nextInt(50), this.random.nextInt(50), 200 + this.random.nextInt(55)), 0.25f + this.damage * 0.05f, 20 + Math.round(this.damage * 0.025f), 0.9f), this.getX() + dx * (double)i, this.getY() + dy * (double)i, this.getZ() + dz * (double)i, -this.getDeltaMovement().x * 0.1 * Math.random(), -this.getDeltaMovement().y * 0.1 * Math.random(), -this.getDeltaMovement().z * 0.1 * Math.random());
        }
        this.moveTowardsTargetInArc((Entity)this.target);
        if (this.target.isDeadOrDying()) {
            this.discard();
        }
        if (this.distanceTo((Entity)this.target) <= 1.0f) {
            Level level = this.target.getCommandSenderWorld();
            Entity entity = this.getOwner();
            if (entity instanceof Player) {
                Player owner = (Player)entity;
                EntityUtils.hurt((LivingEntity)owner, level.damageSources().playerAttack(owner), this.damage);
            } else {
                this.target.hurt(level.damageSources().generic(), this.damage);
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    private void moveTowardsTargetInArc(Entity target) {
        Vec3 targetPos = new Vec3(target.getX(), target.getY() + (double)(target.getBbHeight() / 2.0f), target.getZ());
        Vec3 direction = targetPos.subtract(this.position()).normalize();
        this.setDeltaMovement(this.position().add(direction.add(new Vec3((double)this.getDirectionChoice() * -direction.z, 0.0, (double)this.getDirectionChoice() * direction.x))).subtract(this.position()).normalize().scale(this.position().distanceTo(targetPos) * (double)((float)this.tickCount * 0.01f)));
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity entity;
        Entity entity2;
        if (this.target == null || !((entity2 = result.getEntity()) instanceof LivingEntity) || (entity = (LivingEntity)entity2).getUUID() != this.target.getUUID()) {
            return;
        }
        entity.hurt(this.level().damageSources().generic(), this.damage);
        this.discard();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DIRECTION_CHOICE, (Object)Float.valueOf(0.0f));
    }

    public boolean isNoGravity() {
        return true;
    }

    public float getDirectionChoice() {
        return ((Float)this.entityData.get(DIRECTION_CHOICE)).floatValue();
    }

    public void setDirectionChoice(float value) {
        this.entityData.set(DIRECTION_CHOICE, (Object)Float.valueOf(value));
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }
}

